/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.inmemory.datastore.provider.rev140617.modules.module.configuration.inmemory.operational.datastore.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.inmemory.datastore.provider.rev140617.DatastoreConfiguration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.inmemory.datastore.provider.rev140617.modules.module.configuration.inmemory.operational.datastore.provider.InmemoryOperationalDatastoreProvider;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.inmemory.datastore.provider.rev140617.modules.module.configuration.inmemory.operational.datastore.provider.inmemory.operational.datastore.provider.SchemaService;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InmemoryOperationalDatastoreProviderBuilder
implements Builder<InmemoryOperationalDatastoreProvider> {
    private Integer _maxDataChangeExecutorPoolSize;
    private Integer _maxDataChangeExecutorQueueSize;
    private Integer _maxDataChangeListenerQueueSize;
    private Integer _maxDataStoreExecutorQueueSize;
    private SchemaService _schemaService;
    private Boolean _debugTransactions;
    Map<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>> augmentation = Collections.emptyMap();

    public InmemoryOperationalDatastoreProviderBuilder() {
    }

    public InmemoryOperationalDatastoreProviderBuilder(DatastoreConfiguration arg) {
        this._maxDataChangeExecutorQueueSize = arg.getMaxDataChangeExecutorQueueSize();
        this._maxDataChangeExecutorPoolSize = arg.getMaxDataChangeExecutorPoolSize();
        this._maxDataChangeListenerQueueSize = arg.getMaxDataChangeListenerQueueSize();
        this._maxDataStoreExecutorQueueSize = arg.getMaxDataStoreExecutorQueueSize();
        this._debugTransactions = arg.isDebugTransactions();
    }

    public InmemoryOperationalDatastoreProviderBuilder(InmemoryOperationalDatastoreProvider base) {
        AugmentationHolder casted;
        this._maxDataChangeExecutorPoolSize = base.getMaxDataChangeExecutorPoolSize();
        this._maxDataChangeExecutorQueueSize = base.getMaxDataChangeExecutorQueueSize();
        this._maxDataChangeListenerQueueSize = base.getMaxDataChangeListenerQueueSize();
        this._maxDataStoreExecutorQueueSize = base.getMaxDataStoreExecutorQueueSize();
        this._schemaService = base.getSchemaService();
        this._debugTransactions = base.isDebugTransactions();
        if (base instanceof InmemoryOperationalDatastoreProviderImpl) {
            InmemoryOperationalDatastoreProviderImpl impl = (InmemoryOperationalDatastoreProviderImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DatastoreConfiguration) {
            this._maxDataChangeExecutorQueueSize = ((DatastoreConfiguration)arg).getMaxDataChangeExecutorQueueSize();
            this._maxDataChangeExecutorPoolSize = ((DatastoreConfiguration)arg).getMaxDataChangeExecutorPoolSize();
            this._maxDataChangeListenerQueueSize = ((DatastoreConfiguration)arg).getMaxDataChangeListenerQueueSize();
            this._maxDataStoreExecutorQueueSize = ((DatastoreConfiguration)arg).getMaxDataStoreExecutorQueueSize();
            this._debugTransactions = ((DatastoreConfiguration)arg).isDebugTransactions();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.inmemory.datastore.provider.rev140617.DatastoreConfiguration] \nbut was: " + arg);
        }
    }

    public Integer getMaxDataChangeExecutorPoolSize() {
        return this._maxDataChangeExecutorPoolSize;
    }

    public Integer getMaxDataChangeExecutorQueueSize() {
        return this._maxDataChangeExecutorQueueSize;
    }

    public Integer getMaxDataChangeListenerQueueSize() {
        return this._maxDataChangeListenerQueueSize;
    }

    public Integer getMaxDataStoreExecutorQueueSize() {
        return this._maxDataStoreExecutorQueueSize;
    }

    public SchemaService getSchemaService() {
        return this._schemaService;
    }

    public Boolean isDebugTransactions() {
        return this._debugTransactions;
    }

    public <E extends Augmentation<InmemoryOperationalDatastoreProvider>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaxDataChangeExecutorPoolSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public InmemoryOperationalDatastoreProviderBuilder setMaxDataChangeExecutorPoolSize(Integer value) {
        if (value != null) {
            InmemoryOperationalDatastoreProviderBuilder.checkMaxDataChangeExecutorPoolSizeRange(value);
        }
        this._maxDataChangeExecutorPoolSize = value;
        return this;
    }

    private static void checkMaxDataChangeExecutorQueueSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public InmemoryOperationalDatastoreProviderBuilder setMaxDataChangeExecutorQueueSize(Integer value) {
        if (value != null) {
            InmemoryOperationalDatastoreProviderBuilder.checkMaxDataChangeExecutorQueueSizeRange(value);
        }
        this._maxDataChangeExecutorQueueSize = value;
        return this;
    }

    private static void checkMaxDataChangeListenerQueueSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public InmemoryOperationalDatastoreProviderBuilder setMaxDataChangeListenerQueueSize(Integer value) {
        if (value != null) {
            InmemoryOperationalDatastoreProviderBuilder.checkMaxDataChangeListenerQueueSizeRange(value);
        }
        this._maxDataChangeListenerQueueSize = value;
        return this;
    }

    private static void checkMaxDataStoreExecutorQueueSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public InmemoryOperationalDatastoreProviderBuilder setMaxDataStoreExecutorQueueSize(Integer value) {
        if (value != null) {
            InmemoryOperationalDatastoreProviderBuilder.checkMaxDataStoreExecutorQueueSizeRange(value);
        }
        this._maxDataStoreExecutorQueueSize = value;
        return this;
    }

    public InmemoryOperationalDatastoreProviderBuilder setSchemaService(SchemaService value) {
        this._schemaService = value;
        return this;
    }

    public InmemoryOperationalDatastoreProviderBuilder setDebugTransactions(Boolean value) {
        this._debugTransactions = value;
        return this;
    }

    public InmemoryOperationalDatastoreProviderBuilder addAugmentation(Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>> augmentationType, Augmentation<InmemoryOperationalDatastoreProvider> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InmemoryOperationalDatastoreProviderBuilder removeAugmentation(Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InmemoryOperationalDatastoreProvider build() {
        return new InmemoryOperationalDatastoreProviderImpl(this);
    }

    private static final class InmemoryOperationalDatastoreProviderImpl
    implements InmemoryOperationalDatastoreProvider {
        private final Integer _maxDataChangeExecutorPoolSize;
        private final Integer _maxDataChangeExecutorQueueSize;
        private final Integer _maxDataChangeListenerQueueSize;
        private final Integer _maxDataStoreExecutorQueueSize;
        private final SchemaService _schemaService;
        private final Boolean _debugTransactions;
        private Map<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InmemoryOperationalDatastoreProvider> getImplementedInterface() {
            return InmemoryOperationalDatastoreProvider.class;
        }

        private InmemoryOperationalDatastoreProviderImpl(InmemoryOperationalDatastoreProviderBuilder base) {
            this._maxDataChangeExecutorPoolSize = base.getMaxDataChangeExecutorPoolSize();
            this._maxDataChangeExecutorQueueSize = base.getMaxDataChangeExecutorQueueSize();
            this._maxDataChangeListenerQueueSize = base.getMaxDataChangeListenerQueueSize();
            this._maxDataStoreExecutorQueueSize = base.getMaxDataStoreExecutorQueueSize();
            this._schemaService = base.getSchemaService();
            this._debugTransactions = base.isDebugTransactions();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxDataChangeExecutorPoolSize() {
            return this._maxDataChangeExecutorPoolSize;
        }

        @Override
        public Integer getMaxDataChangeExecutorQueueSize() {
            return this._maxDataChangeExecutorQueueSize;
        }

        @Override
        public Integer getMaxDataChangeListenerQueueSize() {
            return this._maxDataChangeListenerQueueSize;
        }

        @Override
        public Integer getMaxDataStoreExecutorQueueSize() {
            return this._maxDataStoreExecutorQueueSize;
        }

        @Override
        public SchemaService getSchemaService() {
            return this._schemaService;
        }

        @Override
        public Boolean isDebugTransactions() {
            return this._debugTransactions;
        }

        public <E extends Augmentation<InmemoryOperationalDatastoreProvider>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxDataChangeExecutorPoolSize);
            result = 31 * result + Objects.hashCode(this._maxDataChangeExecutorQueueSize);
            result = 31 * result + Objects.hashCode(this._maxDataChangeListenerQueueSize);
            result = 31 * result + Objects.hashCode(this._maxDataStoreExecutorQueueSize);
            result = 31 * result + Objects.hashCode(this._schemaService);
            result = 31 * result + Objects.hashCode(this._debugTransactions);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InmemoryOperationalDatastoreProvider.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InmemoryOperationalDatastoreProvider other = (InmemoryOperationalDatastoreProvider)obj;
            if (!Objects.equals(this._maxDataChangeExecutorPoolSize, other.getMaxDataChangeExecutorPoolSize())) {
                return false;
            }
            if (!Objects.equals(this._maxDataChangeExecutorQueueSize, other.getMaxDataChangeExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._maxDataChangeListenerQueueSize, other.getMaxDataChangeListenerQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._maxDataStoreExecutorQueueSize, other.getMaxDataStoreExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._schemaService, other.getSchemaService())) {
                return false;
            }
            if (!Objects.equals(this._debugTransactions, other.isDebugTransactions())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InmemoryOperationalDatastoreProviderImpl otherImpl = (InmemoryOperationalDatastoreProviderImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InmemoryOperationalDatastoreProvider>>, Augmentation<InmemoryOperationalDatastoreProvider>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InmemoryOperationalDatastoreProvider [";
            StringBuilder builder = new StringBuilder(name);
            if (this._maxDataChangeExecutorPoolSize != null) {
                builder.append("_maxDataChangeExecutorPoolSize=");
                builder.append(this._maxDataChangeExecutorPoolSize);
                builder.append(", ");
            }
            if (this._maxDataChangeExecutorQueueSize != null) {
                builder.append("_maxDataChangeExecutorQueueSize=");
                builder.append(this._maxDataChangeExecutorQueueSize);
                builder.append(", ");
            }
            if (this._maxDataChangeListenerQueueSize != null) {
                builder.append("_maxDataChangeListenerQueueSize=");
                builder.append(this._maxDataChangeListenerQueueSize);
                builder.append(", ");
            }
            if (this._maxDataStoreExecutorQueueSize != null) {
                builder.append("_maxDataStoreExecutorQueueSize=");
                builder.append(this._maxDataStoreExecutorQueueSize);
                builder.append(", ");
            }
            if (this._schemaService != null) {
                builder.append("_schemaService=");
                builder.append(this._schemaService);
                builder.append(", ");
            }
            if (this._debugTransactions != null) {
                builder.append("_debugTransactions=");
                builder.append(this._debugTransactions);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

