/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public final class DOMImmutableDataChangeEvent
implements AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> {
    private static final RemoveEventFactory REMOVE_EVENT_FACTORY = new RemoveEventFactory();
    private static final CreateEventFactory CREATE_EVENT_FACTORY = new CreateEventFactory();
    private final NormalizedNode<?, ?> original;
    private final NormalizedNode<?, ?> updated;
    private final Map<YangInstanceIdentifier, NormalizedNode<?, ?>> originalData;
    private final Map<YangInstanceIdentifier, NormalizedNode<?, ?>> createdData;
    private final Map<YangInstanceIdentifier, NormalizedNode<?, ?>> updatedData;
    private final Set<YangInstanceIdentifier> removedPaths;
    private final AsyncDataBroker.DataChangeScope scope;

    private DOMImmutableDataChangeEvent(Builder change) {
        this.original = change.before;
        this.updated = change.after;
        this.originalData = Collections.unmodifiableMap(change.original);
        this.createdData = Collections.unmodifiableMap(change.created);
        this.updatedData = Collections.unmodifiableMap(change.updated);
        this.removedPaths = Collections.unmodifiableSet(change.removed);
        this.scope = change.scope;
    }

    public static final Builder builder(AsyncDataBroker.DataChangeScope scope) {
        return new Builder(scope);
    }

    protected AsyncDataBroker.DataChangeScope getScope() {
        return this.scope;
    }

    public NormalizedNode<?, ?> getOriginalSubtree() {
        return this.original;
    }

    public NormalizedNode<?, ?> getUpdatedSubtree() {
        return this.updated;
    }

    public Map<YangInstanceIdentifier, NormalizedNode<?, ?>> getOriginalData() {
        return this.originalData;
    }

    public Map<YangInstanceIdentifier, NormalizedNode<?, ?>> getCreatedData() {
        return this.createdData;
    }

    public Map<YangInstanceIdentifier, NormalizedNode<?, ?>> getUpdatedData() {
        return this.updatedData;
    }

    public Set<YangInstanceIdentifier> getRemovedPaths() {
        return this.removedPaths;
    }

    public String toString() {
        return "DOMImmutableDataChangeEvent [created=" + this.createdData.keySet() + ", updated=" + this.updatedData.keySet() + ", removed=" + this.removedPaths + "]";
    }

    public static final SimpleEventFactory getCreateEventFactory() {
        return CREATE_EVENT_FACTORY;
    }

    public static final SimpleEventFactory getRemoveEventFactory() {
        return REMOVE_EVENT_FACTORY;
    }

    private static final class CreateEventFactory
    implements SimpleEventFactory {
        private CreateEventFactory() {
        }

        @Override
        public DOMImmutableDataChangeEvent create(YangInstanceIdentifier path, NormalizedNode<YangInstanceIdentifier.PathArgument, ?> data) {
            return DOMImmutableDataChangeEvent.builder(AsyncDataBroker.DataChangeScope.BASE).setAfter(data).addCreated(path, data).build();
        }
    }

    private static final class RemoveEventFactory
    implements SimpleEventFactory {
        private RemoveEventFactory() {
        }

        @Override
        public DOMImmutableDataChangeEvent create(YangInstanceIdentifier path, NormalizedNode<YangInstanceIdentifier.PathArgument, ?> data) {
            return DOMImmutableDataChangeEvent.builder(AsyncDataBroker.DataChangeScope.BASE).setBefore(data).addRemoved(path, data).build();
        }
    }

    public static class Builder {
        public AsyncDataBroker.DataChangeScope scope;
        private NormalizedNode<?, ?> after;
        private NormalizedNode<?, ?> before;
        private final Map<YangInstanceIdentifier, NormalizedNode<?, ?>> original = new HashMap();
        private final Map<YangInstanceIdentifier, NormalizedNode<?, ?>> created = new HashMap();
        private final Map<YangInstanceIdentifier, NormalizedNode<?, ?>> updated = new HashMap();
        private final Set<YangInstanceIdentifier> removed = new HashSet<YangInstanceIdentifier>();

        private Builder(AsyncDataBroker.DataChangeScope scope) {
            Preconditions.checkNotNull((Object)scope, (Object)"Data change scope should not be null.");
            this.scope = scope;
        }

        public Builder setAfter(NormalizedNode<?, ?> node) {
            this.after = node;
            return this;
        }

        public DOMImmutableDataChangeEvent build() {
            return new DOMImmutableDataChangeEvent(this);
        }

        public void merge(DOMImmutableDataChangeEvent nestedChanges) {
            this.original.putAll(nestedChanges.getOriginalData());
            this.created.putAll(nestedChanges.getCreatedData());
            this.updated.putAll(nestedChanges.getUpdatedData());
            this.removed.addAll(nestedChanges.getRemovedPaths());
        }

        public Builder setBefore(NormalizedNode<?, ?> node) {
            this.before = node;
            return this;
        }

        public Builder addCreated(YangInstanceIdentifier path, NormalizedNode<?, ?> node) {
            this.created.put(path, node);
            return this;
        }

        public Builder addRemoved(YangInstanceIdentifier path, NormalizedNode<?, ?> node) {
            this.original.put(path, node);
            this.removed.add(path);
            return this;
        }

        public Builder addUpdated(YangInstanceIdentifier path, NormalizedNode<?, ?> before, NormalizedNode<?, ?> after) {
            this.original.put(path, before);
            this.updated.put(path, after);
            return this;
        }

        public boolean isEmpty() {
            return this.created.isEmpty() && this.removed.isEmpty() && this.updated.isEmpty();
        }
    }

    public static interface SimpleEventFactory {
        public DOMImmutableDataChangeEvent create(YangInstanceIdentifier var1, NormalizedNode<YangInstanceIdentifier.PathArgument, ?> var2);
    }
}

