/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.store.impl.DOMImmutableDataChangeEvent;
import org.opendaylight.controller.md.sal.dom.store.impl.DOMStoreTransactionChainImpl;
import org.opendaylight.controller.md.sal.dom.store.impl.DataChangeListenerRegistration;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMStoreTreeChangePublisher;
import org.opendaylight.controller.md.sal.dom.store.impl.ResolveDataChangeEventsTask;
import org.opendaylight.controller.md.sal.dom.store.impl.tree.ListenerTree;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTreeChangePublisher;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedTransactions;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ExecutorServiceUtil;
import org.opendaylight.yangtools.util.concurrent.NotificationManager;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDOMDataStore
extends SnapshotBackedWriteTransaction.TransactionReadyPrototype<String>
implements DOMStore,
Identifiable<String>,
SchemaContextListener,
AutoCloseable,
DOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMDataStore.class);
    private static final QueuedNotificationManager.Invoker<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent> DCL_NOTIFICATION_MGR_INVOKER = (listener, notification) -> {
        Object inst = listener.getInstance();
        if (inst != null) {
            inst.onDataChanged((AsyncDataChangeEvent)notification);
        }
    };
    private final DataTree dataTree;
    private final ListenerTree listenerTree = ListenerTree.create();
    private final AtomicLong txCounter = new AtomicLong(0L);
    private final QueuedNotificationManager<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent> dataChangeListenerNotificationManager;
    private final InMemoryDOMStoreTreeChangePublisher changePublisher;
    private final ExecutorService dataChangeListenerExecutor;
    private final boolean debugTransactions;
    private final String name;
    private volatile AutoCloseable closeable;

    public InMemoryDOMDataStore(String name, ExecutorService dataChangeListenerExecutor) {
        this(name, LogicalDatastoreType.OPERATIONAL, dataChangeListenerExecutor, 1000, false);
    }

    public InMemoryDOMDataStore(String name, LogicalDatastoreType type, ExecutorService dataChangeListenerExecutor, int maxDataChangeListenerQueueSize, boolean debugTransactions) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.dataChangeListenerExecutor = (ExecutorService)Preconditions.checkNotNull((Object)dataChangeListenerExecutor);
        this.debugTransactions = debugTransactions;
        this.dataChangeListenerNotificationManager = new QueuedNotificationManager((Executor)this.dataChangeListenerExecutor, DCL_NOTIFICATION_MGR_INVOKER, maxDataChangeListenerQueueSize, "DataChangeListenerQueueMgr");
        this.changePublisher = new InMemoryDOMStoreTreeChangePublisher(this.dataChangeListenerExecutor, maxDataChangeListenerQueueSize);
        switch (type) {
            case CONFIGURATION: {
                this.dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_CONFIGURATION);
                break;
            }
            case OPERATIONAL: {
                this.dataTree = new InMemoryDataTreeFactory().create(DataTreeConfiguration.DEFAULT_OPERATIONAL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data store " + type + " not supported");
            }
        }
    }

    public void setCloseable(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    public QueuedNotificationManager<?, ?> getDataChangeListenerNotificationManager() {
        return this.dataChangeListenerNotificationManager;
    }

    public final String getIdentifier() {
        return this.name;
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return SnapshotBackedTransactions.newReadTransaction((Object)this.nextIdentifier(), (boolean)this.debugTransactions, (DataTreeSnapshot)this.dataTree.takeSnapshot());
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return SnapshotBackedTransactions.newReadWriteTransaction((Object)this.nextIdentifier(), (boolean)this.debugTransactions, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return SnapshotBackedTransactions.newWriteTransaction((Object)this.nextIdentifier(), (boolean)this.debugTransactions, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    public DOMStoreTransactionChain createTransactionChain() {
        return new DOMStoreTransactionChainImpl(this);
    }

    public synchronized void onGlobalContextUpdated(SchemaContext ctx) {
        this.dataTree.setSchemaContext(ctx);
    }

    @Override
    public void close() {
        ExecutorServiceUtil.tryGracefulShutdown((ExecutorService)this.dataChangeListenerExecutor, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.debug("Error closing instance", (Throwable)e);
            }
        }
    }

    public final boolean getDebugTransactions() {
        return this.debugTransactions;
    }

    final DataTreeSnapshot takeSnapshot() {
        return this.dataTree.takeSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>> ListenerRegistration<L> registerChangeListener(YangInstanceIdentifier path, L listener, AsyncDataBroker.DataChangeScope scope) {
        DataChangeListenerRegistration<L> reg;
        InMemoryDOMDataStore inMemoryDOMDataStore = this;
        synchronized (inMemoryDOMDataStore) {
            LOG.debug("{}: Registering data change listener {} for {}", new Object[]{this.name, listener, path});
            reg = this.listenerTree.registerDataChangeListener(path, listener, scope);
            Optional currentState = this.dataTree.takeSnapshot().readNode(path);
            if (currentState.isPresent()) {
                NormalizedNode data = (NormalizedNode)currentState.get();
                DOMImmutableDataChangeEvent event = DOMImmutableDataChangeEvent.builder(AsyncDataBroker.DataChangeScope.BASE).setAfter(data).addCreated(path, data).build();
                this.dataChangeListenerNotificationManager.submitNotification(reg, (Object)event);
            }
        }
        return new AbstractListenerRegistration<L>(listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                InMemoryDOMDataStore inMemoryDOMDataStore = InMemoryDOMDataStore.this;
                synchronized (inMemoryDOMDataStore) {
                    reg.close();
                }
            }
        };
    }

    public synchronized <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener) {
        return this.changePublisher.registerTreeChangeListener(treeId, listener, this.dataTree.takeSnapshot());
    }

    protected void transactionAborted(SnapshotBackedWriteTransaction<String> tx) {
        LOG.debug("Tx: {} is closed.", tx.getIdentifier());
    }

    protected DOMStoreThreePhaseCommitCohort transactionReady(SnapshotBackedWriteTransaction<String> tx, DataTreeModification modification, Exception readyError) {
        LOG.debug("Tx: {} is submitted. Modifications: {}", tx.getIdentifier(), (Object)modification);
        return new InMemoryDOMStoreThreePhaseCommitCohort(this, tx, modification, readyError);
    }

    String nextIdentifier() {
        return this.name + "-" + this.txCounter.getAndIncrement();
    }

    void validate(DataTreeModification modification) throws DataValidationFailedException {
        this.dataTree.validate(modification);
    }

    DataTreeCandidate prepare(DataTreeModification modification) {
        return this.dataTree.prepare(modification);
    }

    synchronized void commit(DataTreeCandidate candidate) {
        this.dataTree.commit(candidate);
        this.changePublisher.publishChange(candidate);
        ResolveDataChangeEventsTask.create(candidate, this.listenerTree).resolve((NotificationManager<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent>)this.dataChangeListenerNotificationManager);
    }
}

