/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.opendaylight.controller.md.sal.common.api.data.OptimisticLockFailedException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMDataStore;
import org.opendaylight.controller.sal.core.spi.data.AbstractDOMStoreTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="Void is the only allowed value")
class InMemoryDOMStoreThreePhaseCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMStoreThreePhaseCommitCohort.class);
    private static final ListenableFuture<Void> SUCCESSFUL_FUTURE = Futures.immediateFuture(null);
    private static final ListenableFuture<Boolean> CAN_COMMIT_FUTURE = Futures.immediateFuture((Object)Boolean.TRUE);
    private final SnapshotBackedWriteTransaction<String> transaction;
    private final DataTreeModification modification;
    private final InMemoryDOMDataStore store;
    private DataTreeCandidate candidate;
    private final Exception operationError;

    public InMemoryDOMStoreThreePhaseCommitCohort(InMemoryDOMDataStore store, SnapshotBackedWriteTransaction<String> writeTransaction, DataTreeModification modification, Exception operationError) {
        this.transaction = (SnapshotBackedWriteTransaction)Preconditions.checkNotNull(writeTransaction);
        this.modification = (DataTreeModification)Preconditions.checkNotNull((Object)modification);
        this.store = (InMemoryDOMDataStore)Preconditions.checkNotNull((Object)store);
        this.operationError = operationError;
    }

    private static void warnDebugContext(AbstractDOMStoreTransaction<?> transaction) {
        Throwable ctx = transaction.getDebugContext();
        if (ctx != null) {
            LOG.warn("Transaction {} has been allocated in the following context", transaction.getIdentifier(), (Object)ctx);
        }
    }

    public final ListenableFuture<Boolean> canCommit() {
        if (this.operationError != null) {
            return Futures.immediateFailedFuture((Throwable)this.operationError);
        }
        try {
            this.store.validate(this.modification);
            LOG.debug("Store Transaction: {} can be committed", this.getTransaction().getIdentifier());
            return CAN_COMMIT_FUTURE;
        }
        catch (ConflictingModificationAppliedException e) {
            LOG.warn("Store Tx: {} Conflicting modification for {}.", this.getTransaction().getIdentifier(), (Object)e.getPath());
            InMemoryDOMStoreThreePhaseCommitCohort.warnDebugContext(this.getTransaction());
            return Futures.immediateFailedFuture((Throwable)new OptimisticLockFailedException("Optimistic lock failed.", (Throwable)e));
        }
        catch (DataValidationFailedException e) {
            LOG.warn("Store Tx: {} Data Precondition failed for {}.", new Object[]{this.getTransaction().getIdentifier(), e.getPath(), e});
            InMemoryDOMStoreThreePhaseCommitCohort.warnDebugContext(this.getTransaction());
            LOG.trace("Store Tx: {} modifications: {} tree: {}", (Object)this.modification, (Object)this.store);
            return Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("Data did not pass validation.", (Throwable)e, new RpcError[0]));
        }
        catch (Exception e) {
            LOG.warn("Unexpected failure in validation phase", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public final ListenableFuture<Void> preCommit() {
        try {
            this.candidate = this.store.prepare(this.modification);
            return SUCCESSFUL_FUTURE;
        }
        catch (Exception e) {
            LOG.warn("Unexpected failure in pre-commit phase", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public final ListenableFuture<Void> abort() {
        this.candidate = null;
        return SUCCESSFUL_FUTURE;
    }

    protected final SnapshotBackedWriteTransaction<String> getTransaction() {
        return this.transaction;
    }

    public ListenableFuture<Void> commit() {
        Preconditions.checkState((this.candidate != null ? 1 : 0) != 0, (Object)"Proposed subtree must be computed");
        this.store.commit(this.candidate);
        return SUCCESSFUL_FUTURE;
    }
}

