/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.store.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.dom.store.impl.DOMImmutableDataChangeEvent;
import org.opendaylight.controller.md.sal.dom.store.impl.DataChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResolveDataChangeState {
    private static final Logger LOG = LoggerFactory.getLogger(ResolveDataChangeState.class);
    private final Iterable<DOMImmutableDataChangeEvent.Builder> inheritedSub;
    private final Collection<DOMImmutableDataChangeEvent.Builder> inheritedOne;
    private final YangInstanceIdentifier nodeId;
    private final Collection<RegistrationTreeNode<DataChangeListenerRegistration<?>>> nodes;
    private final Map<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent.Builder> subBuilders;
    private final Map<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent.Builder> oneBuilders;
    private final Map<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent.Builder> baseBuilders;

    private ResolveDataChangeState(YangInstanceIdentifier nodeId, Iterable<DOMImmutableDataChangeEvent.Builder> inheritedSub, Collection<DOMImmutableDataChangeEvent.Builder> inheritedOne, Collection<RegistrationTreeNode<DataChangeListenerRegistration<?>>> nodes) {
        this.nodeId = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)nodeId);
        this.nodes = (Collection)Preconditions.checkNotNull(nodes);
        this.inheritedSub = (Iterable)Preconditions.checkNotNull(inheritedSub);
        this.inheritedOne = (Collection)Preconditions.checkNotNull(inheritedOne);
        HashMap<DataChangeListenerRegistration, DOMImmutableDataChangeEvent.Builder> sub = new HashMap<DataChangeListenerRegistration, DOMImmutableDataChangeEvent.Builder>();
        HashMap<DataChangeListenerRegistration, DOMImmutableDataChangeEvent.Builder> one = new HashMap<DataChangeListenerRegistration, DOMImmutableDataChangeEvent.Builder>();
        HashMap<DataChangeListenerRegistration, DOMImmutableDataChangeEvent.Builder> base = new HashMap<DataChangeListenerRegistration, DOMImmutableDataChangeEvent.Builder>();
        for (RegistrationTreeNode<DataChangeListenerRegistration<?>> n : nodes) {
            for (DataChangeListenerRegistration l : n.getRegistrations()) {
                DOMImmutableDataChangeEvent.Builder b = DOMImmutableDataChangeEvent.builder(AsyncDataBroker.DataChangeScope.BASE);
                switch (l.getScope()) {
                    case BASE: {
                        base.put(l, b);
                        break;
                    }
                    case ONE: {
                        one.put(l, b);
                        break;
                    }
                    case SUBTREE: {
                        sub.put(l, b);
                    }
                }
            }
        }
        this.baseBuilders = ResolveDataChangeState.maybeEmpty(base);
        this.oneBuilders = ResolveDataChangeState.maybeEmpty(one);
        this.subBuilders = ResolveDataChangeState.maybeEmpty(sub);
    }

    private static <K, V> Map<K, V> maybeEmpty(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return map;
    }

    public static ResolveDataChangeState initial(YangInstanceIdentifier rootId, RegistrationTreeNode<DataChangeListenerRegistration<?>> registrationTreeNode) {
        return new ResolveDataChangeState(rootId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(registrationTreeNode));
    }

    public ResolveDataChangeState child(YangInstanceIdentifier.PathArgument childId) {
        Collection<DOMImmutableDataChangeEvent.Builder> sb = !this.subBuilders.isEmpty() ? (this.inheritedSub instanceof Collection && ((Collection)this.inheritedSub).isEmpty() ? this.subBuilders.values() : Iterables.concat(this.inheritedSub, this.subBuilders.values())) : this.inheritedSub;
        return new ResolveDataChangeState(this.nodeId.node(childId), sb, this.oneBuilders.values(), ResolveDataChangeState.getListenerChildrenWildcarded(this.nodes, childId));
    }

    public YangInstanceIdentifier getPath() {
        return this.nodeId;
    }

    public boolean needsProcessing() {
        if (!this.nodes.isEmpty()) {
            return true;
        }
        if (!this.inheritedOne.isEmpty()) {
            return true;
        }
        if (this.inheritedSub instanceof Collection) {
            return !((Collection)this.inheritedSub).isEmpty();
        }
        return true;
    }

    public void addEvent(DOMImmutableDataChangeEvent event) {
        for (DOMImmutableDataChangeEvent.Builder b : this.subBuilders.values()) {
            b.merge(event);
        }
        for (DOMImmutableDataChangeEvent.Builder b : this.inheritedSub) {
            b.merge(event);
        }
        if (event.getScope() == AsyncDataBroker.DataChangeScope.ONE || event.getScope() == AsyncDataBroker.DataChangeScope.BASE) {
            for (DOMImmutableDataChangeEvent.Builder b : this.oneBuilders.values()) {
                b.merge(event);
            }
        }
        if (event.getScope() == AsyncDataBroker.DataChangeScope.BASE) {
            for (DOMImmutableDataChangeEvent.Builder b : this.inheritedOne) {
                b.merge(event);
            }
            for (DOMImmutableDataChangeEvent.Builder b : this.baseBuilders.values()) {
                b.merge(event);
            }
        }
    }

    public void collectEvents(NormalizedNode<?, ?> before, NormalizedNode<?, ?> after, Multimap<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent> map) {
        DOMImmutableDataChangeEvent.Builder b;
        for (Map.Entry<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent.Builder> e : this.baseBuilders.entrySet()) {
            b = e.getValue();
            if (b.isEmpty()) continue;
            map.put(e.getKey(), (Object)b.setBefore(before).setAfter(after).build());
        }
        for (Map.Entry<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent.Builder> e : this.oneBuilders.entrySet()) {
            b = e.getValue();
            if (b.isEmpty()) continue;
            map.put(e.getKey(), (Object)b.setBefore(before).setAfter(after).build());
        }
        for (Map.Entry<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent.Builder> e : this.subBuilders.entrySet()) {
            b = e.getValue();
            if (b.isEmpty()) continue;
            map.put(e.getKey(), (Object)b.setBefore(before).setAfter(after).build());
        }
        LOG.trace("Collected events {}", map);
    }

    private static Collection<RegistrationTreeNode<DataChangeListenerRegistration<?>>> getListenerChildrenWildcarded(Collection<RegistrationTreeNode<DataChangeListenerRegistration<?>>> parentNodes, YangInstanceIdentifier.PathArgument child) {
        if (parentNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        if (child instanceof YangInstanceIdentifier.NodeWithValue || child instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifier wildcardedIdentifier = new YangInstanceIdentifier.NodeIdentifier(child.getNodeType());
            ResolveDataChangeState.addChildNodes(result, parentNodes, (YangInstanceIdentifier.PathArgument)wildcardedIdentifier);
        }
        ResolveDataChangeState.addChildNodes(result, parentNodes, child);
        return result;
    }

    private static void addChildNodes(List<RegistrationTreeNode<DataChangeListenerRegistration<?>>> result, Collection<RegistrationTreeNode<DataChangeListenerRegistration<?>>> parentNodes, YangInstanceIdentifier.PathArgument childIdentifier) {
        for (RegistrationTreeNode<DataChangeListenerRegistration<?>> node : parentNodes) {
            RegistrationTreeNode child = node.getExactChild(childIdentifier);
            if (child == null) continue;
            result.add(child);
        }
    }
}

