/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.doc.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriInfo;
import org.apache.maven.project.MavenProject;
import org.opendaylight.controller.sal.rest.doc.impl.ApiDocGenerator;
import org.opendaylight.controller.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.controller.sal.rest.doc.swagger.Resource;
import org.opendaylight.controller.sal.rest.doc.swagger.ResourceList;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang2sources.spi.BasicCodeGenerator;
import org.opendaylight.yangtools.yang2sources.spi.MavenProjectAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDocGenerator
extends ApiDocGenerator
implements BasicCodeGenerator,
MavenProjectAware {
    private static final String DEFAULT_OUTPUT_BASE_DIR_PATH = "target" + File.separator + "generated-resources" + File.separator + "swagger-api-documentation";
    private static final Logger _logger = LoggerFactory.getLogger(ApiDocGenerator.class);
    private MavenProject mavenProject;
    private File projectBaseDir;
    private Map<String, String> additionalConfig;
    private File resourceBaseDir;

    public Collection<File> generateSources(SchemaContext context, File outputDir, Set<Module> yangModules) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        File outputBaseDir = outputDir == null ? new File(DEFAULT_OUTPUT_BASE_DIR_PATH) : outputDir;
        outputBaseDir.mkdirs();
        File resourcesDir = new File(outputBaseDir, "resources");
        resourcesDir.mkdirs();
        File resourcesJsFile = new File(outputBaseDir, "resources.js");
        resourcesJsFile.createNewFile();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(resourcesJsFile));
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ResourceList resourceList = super.getResourceListing(null, context, "");
        String resourceListJson = mapper.writeValueAsString((Object)resourceList);
        resourceListJson = resourceListJson.replace("'", "\\'").replace("\\n", "\\\\n");
        bufferedWriter.write("function getSpec() {\n\treturn '" + resourceListJson + "';\n}\n\n");
        bufferedWriter.write("function jsonFor(resource) {\n\tswitch(resource) {\n");
        for (Resource resource : resourceList.getApis()) {
            int revisionIndex = resource.getPath().indexOf(40);
            String name = resource.getPath().substring(0, revisionIndex);
            String revision = resource.getPath().substring(revisionIndex + 1, resource.getPath().length() - 1);
            ApiDeclaration apiDeclaration = super.getApiDeclaration(name, revision, null, context, "");
            String json = mapper.writeValueAsString((Object)apiDeclaration);
            json = json.replace("\"models\":{}", "\"models\":" + apiDeclaration.getModels().toString().replace("\\\"", "\""));
            json = json.replace("'", "\\'").replace("\\n", "\\\\n");
            bufferedWriter.write("\t\tcase \"" + name + "(" + revision + ")\": return '" + json + "';\n");
            File resourceFile = new File(resourcesDir, name + "(" + revision + ").json");
            BufferedWriter resourceFileWriter = new BufferedWriter(new FileWriter(resourceFile));
            resourceFileWriter.write(json);
            resourceFileWriter.close();
            result.add(resourceFile);
        }
        bufferedWriter.write("\t}\n\treturn \"\";\n}");
        bufferedWriter.close();
        result.add(resourcesJsFile);
        return result;
    }

    protected String generatePath(UriInfo uriInfo, String name, String revision) {
        if (uriInfo == null) {
            return name + "(" + revision + ")";
        }
        return super.generatePath(uriInfo, name, revision);
    }

    protected String createBasePathFromUriInfo(UriInfo uriInfo) {
        if (uriInfo == null) {
            return "restconf";
        }
        return super.createBasePathFromUriInfo(uriInfo);
    }

    public void setAdditionalConfig(Map<String, String> additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    public void setResourceBaseDir(File resourceBaseDir) {
        this.resourceBaseDir = resourceBaseDir;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        this.projectBaseDir = mavenProject.getBasedir();
    }
}

