/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionListener;
import org.opendaylight.controller.sal.rest.doc.impl.ApiDocGenerator;
import org.opendaylight.controller.sal.rest.doc.mountpoints.MountPointSwagger;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocProvider
implements BundleActivator,
ServiceTrackerCustomizer<Broker, Broker>,
Provider,
AutoCloseable {
    private final Logger _logger = LoggerFactory.getLogger(DocProvider.class);
    private ServiceTracker<Broker, Broker> brokerServiceTracker;
    private BundleContext bundleContext;
    private Broker.ProviderSession session;
    private final List<AutoCloseable> toClose = new LinkedList<AutoCloseable>();

    @Override
    public void close() throws Exception {
        this.stop(this.bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionInitiated(Broker.ProviderSession providerSession) {
        SchemaService schemaService = (SchemaService)providerSession.getService(SchemaService.class);
        ApiDocGenerator.getInstance().setSchemaService(schemaService);
        DOMMountPointService mountService = (DOMMountPointService)providerSession.getService(DOMMountPointService.class);
        ListenerRegistration registration = mountService.registerProvisionListener((MountProvisionListener)MountPointSwagger.getInstance());
        MountPointSwagger.getInstance().setGlobalSchema(schemaService);
        List<AutoCloseable> list = this.toClose;
        synchronized (list) {
            this.toClose.add((AutoCloseable)registration);
        }
        MountPointSwagger.getInstance().setMountService(mountService);
        this._logger.debug("Restconf API Explorer started");
    }

    public Collection<Provider.ProviderFunctionality> getProviderFunctionality() {
        return Collections.emptySet();
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.brokerServiceTracker = new ServiceTracker(context, Broker.class, (ServiceTrackerCustomizer)this);
        this.brokerServiceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        if (this.brokerServiceTracker != null) {
            this.brokerServiceTracker.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        List<AutoCloseable> list = this.toClose;
        synchronized (list) {
            for (AutoCloseable close : this.toClose) {
                close.close();
            }
        }
    }

    public Broker addingService(ServiceReference<Broker> reference) {
        Broker broker = (Broker)this.bundleContext.getService(reference);
        this.session = broker.registerProvider((Provider)this, this.bundleContext);
        return broker;
    }

    public void modifiedService(ServiceReference<Broker> reference, Broker service) {
        if (this.session != null) {
            this.session.close();
        }
        Broker broker = (Broker)this.bundleContext.getService(reference);
        this.session = broker.registerProvider((Provider)this, this.bundleContext);
    }

    public void removedService(ServiceReference<Broker> reference, Broker service) {
        this.bundleContext.ungetService(reference);
    }
}

