/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.doc.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.json.JSONWriter;
import org.opendaylight.controller.sal.rest.doc.api.ApiDocService;
import org.opendaylight.controller.sal.rest.doc.impl.ApiDocGenerator;
import org.opendaylight.controller.sal.rest.doc.mountpoints.MountPointSwagger;
import org.opendaylight.controller.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.controller.sal.rest.doc.swagger.ResourceList;

public class ApiDocServiceImpl
implements ApiDocService {
    private static final ApiDocService INSTANCE = new ApiDocServiceImpl();

    public static ApiDocService getInstance() {
        return INSTANCE;
    }

    @Override
    public synchronized Response getRootDoc(UriInfo uriInfo) {
        ApiDocGenerator generator = ApiDocGenerator.getInstance();
        ResourceList rootDoc = generator.getResourceListing(uriInfo);
        return Response.ok((Object)rootDoc).build();
    }

    @Override
    public synchronized Response getDocByModule(String module, String revision, UriInfo uriInfo) {
        ApiDocGenerator generator = ApiDocGenerator.getInstance();
        ApiDeclaration doc = generator.getApiDeclaration(module, revision, uriInfo);
        return Response.ok((Object)doc).build();
    }

    @Override
    public synchronized Response getApiExplorer(UriInfo uriInfo) {
        return Response.seeOther((URI)uriInfo.getBaseUriBuilder().path("../explorer/index.html").build(new Object[0])).build();
    }

    @Override
    public synchronized Response getListOfMounts(UriInfo uriInfo) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter streamWriter = new OutputStreamWriter(baos);){
            JSONWriter writer = new JSONWriter((Writer)streamWriter);
            writer.array();
            for (Map.Entry<String, Long> entry : MountPointSwagger.getInstance().getInstanceIdentifiers().entrySet()) {
                writer.object();
                writer.key("instance").value((Object)entry.getKey());
                writer.key("id").value((Object)entry.getValue());
                writer.endObject();
            }
            writer.endArray();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
        return Response.status((int)200).entity((Object)baos.toString()).build();
    }

    @Override
    public synchronized Response getMountRootDoc(String instanceNum, UriInfo uriInfo) {
        ResourceList resourceList = MountPointSwagger.getInstance().getResourceList(uriInfo, Long.parseLong(instanceNum));
        return Response.ok((Object)resourceList).build();
    }

    @Override
    public synchronized Response getMountDocByModule(String instanceNum, String module, String revision, UriInfo uriInfo) {
        ApiDeclaration api = MountPointSwagger.getInstance().getMountPointApi(uriInfo, Long.parseLong(instanceNum), module, revision);
        return Response.ok((Object)api).build();
    }
}

