/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.doc.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.UriInfo;
import org.json.JSONException;
import org.json.JSONObject;
import org.opendaylight.controller.sal.rest.doc.impl.ModelGenerator;
import org.opendaylight.controller.sal.rest.doc.model.builder.OperationBuilder;
import org.opendaylight.controller.sal.rest.doc.swagger.Api;
import org.opendaylight.controller.sal.rest.doc.swagger.ApiDeclaration;
import org.opendaylight.controller.sal.rest.doc.swagger.Operation;
import org.opendaylight.controller.sal.rest.doc.swagger.Parameter;
import org.opendaylight.controller.sal.rest.doc.swagger.Resource;
import org.opendaylight.controller.sal.rest.doc.swagger.ResourceList;
import org.opendaylight.controller.sal.rest.doc.util.RestDocgenUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseYangSwaggerGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(BaseYangSwaggerGenerator.class);
    protected static final String API_VERSION = "1.0.0";
    protected static final String SWAGGER_VERSION = "1.2";
    protected static final String RESTCONF_CONTEXT_ROOT = "restconf";
    static final String MODULE_NAME_SUFFIX = "_module";
    private final ModelGenerator jsonConverter = new ModelGenerator();
    private final ObjectMapper mapper = new ObjectMapper();

    protected BaseYangSwaggerGenerator() {
        this.mapper.registerModule((com.fasterxml.jackson.databind.Module)new JsonOrgModule());
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }

    public ResourceList getResourceListing(UriInfo uriInfo, SchemaContext schemaContext, String context) {
        ResourceList resourceList = this.createResourceList();
        SortedSet<Module> modules = this.getSortedModules(schemaContext);
        ArrayList<Resource> resources = new ArrayList<Resource>(modules.size());
        LOG.info("Modules found [{}]", (Object)modules.size());
        for (Module module : modules) {
            String revisionString = SimpleDateFormatUtil.getRevisionFormat().format(module.getRevision());
            Resource resource = new Resource();
            LOG.debug("Working on [{},{}]...", (Object)module.getName(), (Object)revisionString);
            ApiDeclaration doc = this.getApiDeclaration(module.getName(), revisionString, uriInfo, schemaContext, context);
            if (doc != null) {
                resource.setPath(this.generatePath(uriInfo, module.getName(), revisionString));
                resources.add(resource);
                continue;
            }
            LOG.debug("Could not generate doc for {},{}", (Object)module.getName(), (Object)revisionString);
        }
        resourceList.setApis(resources);
        return resourceList;
    }

    protected ResourceList createResourceList() {
        ResourceList resourceList = new ResourceList();
        resourceList.setApiVersion(API_VERSION);
        resourceList.setSwaggerVersion(SWAGGER_VERSION);
        return resourceList;
    }

    protected String generatePath(UriInfo uriInfo, String name, String revision) {
        URI uri = uriInfo.getRequestUriBuilder().path(this.generateCacheKey(name, revision)).build(new Object[0]);
        return uri.toASCIIString();
    }

    public ApiDeclaration getApiDeclaration(String module, String revision, UriInfo uriInfo, SchemaContext schemaContext, String context) {
        Module m;
        Date rev = null;
        try {
            if (revision != null && !revision.equals("0000-00-00")) {
                rev = SimpleDateFormatUtil.getRevisionFormat().parse(revision);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        if (rev != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(rev);
            if (cal.get(1) < 1970) {
                rev = null;
            }
        }
        Preconditions.checkArgument(((m = schemaContext.findModuleByName(module, rev)) != null ? 1 : 0) != 0, (Object)("Could not find module by name,revision: " + module + "," + revision));
        return this.getApiDeclaration(m, rev, uriInfo, context, schemaContext);
    }

    public ApiDeclaration getApiDeclaration(Module module, Date revision, UriInfo uriInfo, String context, SchemaContext schemaContext) {
        String basePath = this.createBasePathFromUriInfo(uriInfo);
        ApiDeclaration doc = this.getSwaggerDocSpec(module, basePath, context, schemaContext);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    protected String createBasePathFromUriInfo(UriInfo uriInfo) {
        String portPart = "";
        int port = uriInfo.getBaseUri().getPort();
        if (port != -1) {
            portPart = ":" + port;
        }
        String basePath = uriInfo.getBaseUri().getScheme() + "://" + uriInfo.getBaseUri().getHost() + portPart + "/" + RESTCONF_CONTEXT_ROOT;
        return basePath;
    }

    public ApiDeclaration getSwaggerDocSpec(Module m, String basePath, String context, SchemaContext schemaContext) {
        String resourcePath;
        ApiDeclaration doc = this.createApiDeclaration(basePath);
        ArrayList<Api> apis = new ArrayList<Api>();
        Collection dataSchemaNodes = m.getChildNodes();
        LOG.debug("child nodes size [{}]", (Object)dataSchemaNodes.size());
        for (DataSchemaNode node : dataSchemaNodes) {
            if (!(node instanceof ListSchemaNode) && !(node instanceof ContainerSchemaNode)) continue;
            LOG.debug("Is Configuration node [{}] [{}]", (Object)node.isConfiguration(), (Object)node.getQName().getLocalName());
            ArrayList<Parameter> pathParams = new ArrayList<Parameter>();
            resourcePath = this.getDataStorePath("/config/", context);
            this.addRootPostLink(m, (DataNodeContainer)node, pathParams, resourcePath, apis);
            this.addApis(node, apis, resourcePath, pathParams, schemaContext, true);
            pathParams = new ArrayList();
            resourcePath = this.getDataStorePath("/operational/", context);
            this.addApis(node, apis, resourcePath, pathParams, schemaContext, false);
        }
        Set rpcs = m.getRpcs();
        for (RpcDefinition rpcDefinition : rpcs) {
            resourcePath = this.getDataStorePath("/operations/", context);
            this.addRpcs(rpcDefinition, apis, resourcePath, schemaContext);
        }
        LOG.debug("Number of APIs found [{}]", (Object)apis.size());
        if (!apis.isEmpty()) {
            doc.setApis(apis);
            JSONObject models = null;
            try {
                models = this.jsonConverter.convertToJsonSchema(m, schemaContext);
                doc.setModels(models);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.mapper.writeValueAsString((Object)doc));
                }
            }
            catch (IOException | JSONException e) {
                e.printStackTrace();
            }
            return doc;
        }
        return null;
    }

    private void addRootPostLink(Module m, DataNodeContainer node, List<Parameter> pathParams, String resourcePath, List<Api> apis) {
        if (this.containsListOrContainer(m.getChildNodes())) {
            Api apiForRootPostUri = new Api();
            apiForRootPostUri.setPath(resourcePath);
            apiForRootPostUri.setOperations(this.operationPost(m.getName() + MODULE_NAME_SUFFIX, m.getDescription(), (DataNodeContainer)m, pathParams, true));
            apis.add(apiForRootPostUri);
        }
    }

    protected ApiDeclaration createApiDeclaration(String basePath) {
        ApiDeclaration doc = new ApiDeclaration();
        doc.setApiVersion(API_VERSION);
        doc.setSwaggerVersion(SWAGGER_VERSION);
        doc.setBasePath(basePath);
        doc.setProduces(Arrays.asList("application/json", "application/xml"));
        return doc;
    }

    protected String getDataStorePath(String dataStore, String context) {
        return dataStore + context;
    }

    private String generateCacheKey(Module m) {
        return this.generateCacheKey(m.getName(), SimpleDateFormatUtil.getRevisionFormat().format(m.getRevision()));
    }

    private String generateCacheKey(String module, String revision) {
        return module + "(" + revision + ")";
    }

    private void addApis(DataSchemaNode node, List<Api> apis, String parentPath, List<Parameter> parentPathParams, SchemaContext schemaContext, boolean addConfigApi) {
        Api api = new Api();
        ArrayList<Parameter> pathParams = new ArrayList<Parameter>(parentPathParams);
        String resourcePath = parentPath + this.createPath(node, pathParams, schemaContext) + "/";
        LOG.debug("Adding path: [{}]", (Object)resourcePath);
        api.setPath(resourcePath);
        Set<DataSchemaNode> childSchemaNodes = Collections.emptySet();
        if (node instanceof ListSchemaNode || node instanceof ContainerSchemaNode) {
            DataNodeContainer dataNodeContainer = (DataNodeContainer)node;
            childSchemaNodes = dataNodeContainer.getChildNodes();
        }
        api.setOperations(this.operation(node, pathParams, addConfigApi, childSchemaNodes));
        apis.add(api);
        for (DataSchemaNode childNode : childSchemaNodes) {
            if (!(childNode instanceof ListSchemaNode) && !(childNode instanceof ContainerSchemaNode) || childNode.isConfiguration() != addConfigApi) continue;
            this.addApis(childNode, apis, resourcePath, pathParams, schemaContext, addConfigApi);
        }
    }

    private boolean containsListOrContainer(Iterable<DataSchemaNode> nodes) {
        for (DataSchemaNode child : nodes) {
            if (!(child instanceof ListSchemaNode) && !(child instanceof ContainerSchemaNode)) continue;
            return true;
        }
        return false;
    }

    private List<Operation> operation(DataSchemaNode node, List<Parameter> pathParams, boolean isConfig, Iterable<DataSchemaNode> childSchemaNodes) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        OperationBuilder.Get getBuilder = new OperationBuilder.Get(node, isConfig);
        operations.add(getBuilder.pathParams(pathParams).build());
        if (isConfig) {
            OperationBuilder.Put putBuilder = new OperationBuilder.Put(node.getQName().getLocalName(), node.getDescription());
            operations.add(putBuilder.pathParams(pathParams).build());
            OperationBuilder.Delete deleteBuilder = new OperationBuilder.Delete(node);
            operations.add(deleteBuilder.pathParams(pathParams).build());
            if (this.containsListOrContainer(childSchemaNodes)) {
                operations.addAll(this.operationPost(node.getQName().getLocalName(), node.getDescription(), (DataNodeContainer)node, pathParams, isConfig));
            }
        }
        return operations;
    }

    private List<Operation> operationPost(String name, String description, DataNodeContainer dataNodeContainer, List<Parameter> pathParams, boolean isConfig) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (isConfig) {
            OperationBuilder.Post postBuilder = new OperationBuilder.Post(name, description, dataNodeContainer);
            operations.add(postBuilder.pathParams(pathParams).build());
        }
        return operations;
    }

    private String createPath(DataSchemaNode schemaNode, List<Parameter> pathParams, SchemaContext schemaContext) {
        ArrayList<LeafSchemaNode> pathListParams = new ArrayList<LeafSchemaNode>();
        StringBuilder path = new StringBuilder();
        String localName = RestDocgenUtil.resolvePathArgumentsName((SchemaNode)schemaNode, schemaContext);
        path.append(localName);
        if (schemaNode instanceof ListSchemaNode) {
            List listKeys = ((ListSchemaNode)schemaNode).getKeyDefinition();
            for (QName listKey : listKeys) {
                DataSchemaNode _dataChildByName = ((DataNodeContainer)schemaNode).getDataChildByName(listKey);
                pathListParams.add((LeafSchemaNode)_dataChildByName);
                String pathParamIdentifier = "/{" + listKey.getLocalName() + "}";
                path.append(pathParamIdentifier);
                Parameter pathParam = new Parameter();
                pathParam.setName(listKey.getLocalName());
                pathParam.setDescription(_dataChildByName.getDescription());
                pathParam.setType("string");
                pathParam.setParamType("path");
                pathParams.add(pathParam);
            }
        }
        return path.toString();
    }

    protected void addRpcs(RpcDefinition rpcDefn, List<Api> apis, String parentPath, SchemaContext schemaContext) {
        Api rpc = new Api();
        String resourcePath = parentPath + RestDocgenUtil.resolvePathArgumentsName((SchemaNode)rpcDefn, schemaContext);
        rpc.setPath(resourcePath);
        Operation operationSpec = new Operation();
        operationSpec.setMethod("POST");
        operationSpec.setNotes(rpcDefn.getDescription());
        operationSpec.setNickname(rpcDefn.getQName().getLocalName());
        if (rpcDefn.getOutput() != null) {
            operationSpec.setType("(" + rpcDefn.getQName().getLocalName() + ")output");
        }
        if (rpcDefn.getInput() != null) {
            Parameter payload = new Parameter();
            payload.setParamType("body");
            payload.setType("(" + rpcDefn.getQName().getLocalName() + ")input");
            operationSpec.setParameters(Collections.singletonList(payload));
            operationSpec.setConsumes(OperationBuilder.CONSUMES_PUT_POST);
        }
        rpc.setOperations(Arrays.asList(operationSpec));
        apis.add(rpc);
    }

    protected SortedSet<Module> getSortedModules(SchemaContext schemaContext) {
        if (schemaContext == null) {
            return new TreeSet<Module>();
        }
        Set modules = schemaContext.getModules();
        TreeSet<Module> sortedModules = new TreeSet<Module>(new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                int result = o1.getName().compareTo(o2.getName());
                if (result == 0) {
                    result = o1.getRevision().compareTo(o2.getRevision());
                }
                if (result == 0) {
                    result = o1.getNamespace().compareTo(o2.getNamespace());
                }
                return result;
            }
        });
        for (Module m : modules) {
            if (m == null) continue;
            sortedModules.add(m);
        }
        return sortedModules;
    }
}

