/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.doc.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.BooleanUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opendaylight.controller.sal.rest.doc.util.RestDocgenUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BooleanType;
import org.opendaylight.yangtools.yang.model.util.Decimal64;
import org.opendaylight.yangtools.yang.model.util.EnumerationType;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.model.util.Int16;
import org.opendaylight.yangtools.yang.model.util.Int32;
import org.opendaylight.yangtools.yang.model.util.Int64;
import org.opendaylight.yangtools.yang.model.util.Int8;
import org.opendaylight.yangtools.yang.model.util.StringType;
import org.opendaylight.yangtools.yang.model.util.Uint16;
import org.opendaylight.yangtools.yang.model.util.Uint32;
import org.opendaylight.yangtools.yang.model.util.Uint64;
import org.opendaylight.yangtools.yang.model.util.Uint8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ModelGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ModelGenerator.class);
    private static final String BASE_64 = "base64";
    private static final String BINARY_ENCODING_KEY = "binaryEncoding";
    private static final String MEDIA_KEY = "media";
    private static final String ONE_OF_KEY = "oneOf";
    private static final String UNIQUE_ITEMS_KEY = "uniqueItems";
    private static final String MAX_ITEMS = "maxItems";
    private static final String MIN_ITEMS = "minItems";
    private static final String SCHEMA_URL = "http://json-schema.org/draft-04/schema";
    private static final String SCHEMA_KEY = "$schema";
    private static final String MAX_LENGTH_KEY = "maxLength";
    private static final String MIN_LENGTH_KEY = "minLength";
    private static final String REQUIRED_KEY = "required";
    private static final String REF_KEY = "$ref";
    private static final String ITEMS_KEY = "items";
    private static final String TYPE_KEY = "type";
    private static final String PROPERTIES_KEY = "properties";
    private static final String DESCRIPTION_KEY = "description";
    private static final String OBJECT_TYPE = "object";
    private static final String ARRAY_TYPE = "array";
    private static final String ENUM = "enum";
    private static final String INTEGER = "integer";
    private static final String NUMBER = "number";
    private static final String BOOLEAN = "boolean";
    private static final String STRING = "string";
    private static final String ID_KEY = "id";
    private static final String SUB_TYPES_KEY = "subTypes";
    private static final Map<Class<?>, String> YANG_TYPE_TO_JSON_TYPE_MAPPING;
    private Module topLevelModule;

    public JSONObject convertToJsonSchema(Module module, SchemaContext schemaContext) throws IOException, JSONException {
        JSONObject models = new JSONObject();
        this.topLevelModule = module;
        this.processModules(module, models);
        this.processContainersAndLists(module, models, schemaContext);
        this.processRPCs(module, models, schemaContext);
        this.processIdentities(module, models);
        return models;
    }

    private void processModules(Module module, JSONObject models) throws JSONException {
        this.createConcreteModelForPost(models, module.getName() + "_module", this.createPropertiesForPost((DataNodeContainer)module));
    }

    private void processContainersAndLists(Module module, JSONObject models, SchemaContext schemaContext) throws IOException, JSONException {
        String moduleName = module.getName();
        for (DataSchemaNode childNode : module.getChildNodes()) {
            if (!(childNode instanceof ContainerSchemaNode) && !(childNode instanceof ListSchemaNode)) continue;
            this.processDataNodeContainer((DataNodeContainer)childNode, moduleName, models, true, schemaContext);
            this.processDataNodeContainer((DataNodeContainer)childNode, moduleName, models, false, schemaContext);
        }
    }

    private void processRPCs(Module module, JSONObject models, SchemaContext schemaContext) throws JSONException, IOException {
        Set rpcs = module.getRpcs();
        String moduleName = module.getName();
        for (RpcDefinition rpc : rpcs) {
            ContainerSchemaNode output;
            ContainerSchemaNode input = rpc.getInput();
            if (input != null) {
                JSONObject inputJSON = this.processDataNodeContainer((DataNodeContainer)input, moduleName, models, schemaContext);
                String filename = "(" + rpc.getQName().getLocalName() + ")input";
                inputJSON.put(ID_KEY, (Object)filename);
                models.put(filename, (Object)inputJSON);
            }
            if ((output = rpc.getOutput()) == null) continue;
            JSONObject outputJSON = this.processDataNodeContainer((DataNodeContainer)output, moduleName, models, schemaContext);
            String filename = "(" + rpc.getQName().getLocalName() + ")output";
            outputJSON.put(ID_KEY, (Object)filename);
            models.put(filename, (Object)outputJSON);
        }
    }

    private void processIdentities(Module module, JSONObject models) throws JSONException {
        String moduleName = module.getName();
        Set idNodes = module.getIdentities();
        LOG.debug("Processing Identities for module {} . Found {} identity statements", (Object)moduleName, (Object)idNodes.size());
        for (IdentitySchemaNode idNode : idNodes) {
            JSONObject identityObj = new JSONObject();
            String identityName = idNode.getQName().getLocalName();
            LOG.debug("Processing Identity: {}", (Object)identityName);
            identityObj.put(ID_KEY, (Object)identityName);
            identityObj.put(DESCRIPTION_KEY, (Object)idNode.getDescription());
            JSONObject props = new JSONObject();
            IdentitySchemaNode baseId = idNode.getBaseIdentity();
            if (baseId == null) {
                Set derivedIds = idNode.getDerivedIdentities();
                if (derivedIds != null) {
                    JSONArray subTypes = new JSONArray();
                    for (IdentitySchemaNode derivedId : derivedIds) {
                        subTypes.put((Object)derivedId.getQName().getLocalName());
                    }
                    identityObj.put(SUB_TYPES_KEY, (Object)subTypes);
                }
            } else {
                props.put(TYPE_KEY, (Object)baseId.getQName().getLocalName());
            }
            identityObj.put(PROPERTIES_KEY, (Object)props);
            models.put(identityName, (Object)identityObj);
        }
    }

    private JSONObject processDataNodeContainer(DataNodeContainer dataNode, String moduleName, JSONObject models, SchemaContext schemaContext) throws JSONException, IOException {
        return this.processDataNodeContainer(dataNode, moduleName, models, null, schemaContext);
    }

    private JSONObject processDataNodeContainer(DataNodeContainer dataNode, String moduleName, JSONObject models, Boolean isConfig, SchemaContext schemaContext) throws JSONException, IOException {
        if (dataNode instanceof ListSchemaNode || dataNode instanceof ContainerSchemaNode) {
            Preconditions.checkArgument((boolean)(dataNode instanceof SchemaNode), (Object)"Data node should be also schema node");
            Collection containerChildren = dataNode.getChildNodes();
            JSONObject properties = this.processChildren(containerChildren, ((SchemaNode)dataNode).getQName(), moduleName, models, isConfig, schemaContext);
            String nodeName = (BooleanUtils.isNotFalse((Boolean)isConfig) ? "(config)" : "(operational)") + ((SchemaNode)dataNode).getQName().getLocalName();
            JSONObject childSchema = this.getSchemaTemplate();
            childSchema.put(TYPE_KEY, (Object)OBJECT_TYPE);
            childSchema.put(PROPERTIES_KEY, (Object)properties);
            childSchema.put(ID_KEY, (Object)nodeName);
            models.put(nodeName, (Object)childSchema);
            if (BooleanUtils.isNotFalse((Boolean)isConfig)) {
                this.createConcreteModelForPost(models, ((SchemaNode)dataNode).getQName().getLocalName(), this.createPropertiesForPost(dataNode));
            }
            JSONObject items = new JSONObject();
            items.put(REF_KEY, (Object)nodeName);
            JSONObject dataNodeProperties = new JSONObject();
            dataNodeProperties.put(TYPE_KEY, (Object)(dataNode instanceof ListSchemaNode ? ARRAY_TYPE : OBJECT_TYPE));
            dataNodeProperties.put(ITEMS_KEY, (Object)items);
            return dataNodeProperties;
        }
        return null;
    }

    private void createConcreteModelForPost(JSONObject models, String localName, JSONObject properties) throws JSONException {
        String nodePostName = "(config)" + localName + "POST";
        JSONObject postSchema = this.getSchemaTemplate();
        postSchema.put(TYPE_KEY, (Object)OBJECT_TYPE);
        postSchema.put(ID_KEY, (Object)nodePostName);
        postSchema.put(PROPERTIES_KEY, (Object)properties);
        models.put(nodePostName, (Object)postSchema);
    }

    private JSONObject createPropertiesForPost(DataNodeContainer dataNodeContainer) throws JSONException {
        JSONObject properties = new JSONObject();
        for (DataSchemaNode childNode : dataNodeContainer.getChildNodes()) {
            if (childNode instanceof ListSchemaNode || childNode instanceof ContainerSchemaNode) {
                JSONObject items = new JSONObject();
                items.put(REF_KEY, (Object)("(config)" + childNode.getQName().getLocalName()));
                JSONObject property = new JSONObject();
                property.put(TYPE_KEY, (Object)(childNode instanceof ListSchemaNode ? ARRAY_TYPE : OBJECT_TYPE));
                property.put(ITEMS_KEY, (Object)items);
                properties.put(childNode.getQName().getLocalName(), (Object)property);
                continue;
            }
            if (!(childNode instanceof LeafSchemaNode)) continue;
            JSONObject property = this.processLeafNode((LeafSchemaNode)childNode);
            properties.put(childNode.getQName().getLocalName(), (Object)property);
        }
        return properties;
    }

    private JSONObject processChildren(Iterable<DataSchemaNode> nodes, QName parentQName, String moduleName, JSONObject models, SchemaContext schemaContext) throws JSONException, IOException {
        return this.processChildren(nodes, parentQName, moduleName, models, null, schemaContext);
    }

    private JSONObject processChildren(Iterable<DataSchemaNode> nodes, QName parentQName, String moduleName, JSONObject models, Boolean isConfig, SchemaContext schemaContext) throws JSONException, IOException {
        JSONObject properties = new JSONObject();
        for (DataSchemaNode node : nodes) {
            if (isConfig != null && node.isConfiguration() != isConfig.booleanValue()) continue;
            String name = RestDocgenUtil.resolveNodesName((SchemaNode)node, this.topLevelModule, schemaContext);
            JSONObject property = null;
            if (node instanceof LeafSchemaNode) {
                property = this.processLeafNode((LeafSchemaNode)node);
            } else if (node instanceof ListSchemaNode) {
                property = this.processDataNodeContainer((DataNodeContainer)((ListSchemaNode)node), moduleName, models, isConfig, schemaContext);
            } else if (node instanceof LeafListSchemaNode) {
                property = this.processLeafListNode((LeafListSchemaNode)node);
            } else if (node instanceof ChoiceSchemaNode) {
                property = this.processChoiceNode((ChoiceSchemaNode)node, moduleName, models, schemaContext);
            } else if (node instanceof AnyXmlSchemaNode) {
                property = this.processAnyXMLNode((AnyXmlSchemaNode)node);
            } else if (node instanceof ContainerSchemaNode) {
                property = this.processDataNodeContainer((DataNodeContainer)((ContainerSchemaNode)node), moduleName, models, isConfig, schemaContext);
            } else {
                throw new IllegalArgumentException("Unknown DataSchemaNode type: " + node.getClass());
            }
            property.putOpt(DESCRIPTION_KEY, (Object)node.getDescription());
            properties.put(name, (Object)property);
        }
        return properties;
    }

    private JSONObject processLeafListNode(LeafListSchemaNode listNode) throws JSONException {
        JSONObject props = new JSONObject();
        props.put(TYPE_KEY, (Object)ARRAY_TYPE);
        JSONObject itemsVal = new JSONObject();
        this.processTypeDef(listNode.getType(), itemsVal);
        props.put(ITEMS_KEY, (Object)itemsVal);
        ConstraintDefinition constraints = listNode.getConstraints();
        this.processConstraints(constraints, props);
        return props;
    }

    private JSONObject processChoiceNode(ChoiceSchemaNode choiceNode, String moduleName, JSONObject models, SchemaContext schemaContext) throws JSONException, IOException {
        Set cases = choiceNode.getCases();
        JSONArray choiceProps = new JSONArray();
        for (ChoiceCaseNode choiceCase : cases) {
            String choiceName = choiceCase.getQName().getLocalName();
            JSONObject choiceProp = this.processChildren(choiceCase.getChildNodes(), choiceCase.getQName(), moduleName, models, schemaContext);
            JSONObject choiceObj = new JSONObject();
            choiceObj.put(choiceName, (Object)choiceProp);
            choiceObj.put(TYPE_KEY, (Object)OBJECT_TYPE);
            choiceProps.put((Object)choiceObj);
        }
        JSONObject oneOfProps = new JSONObject();
        oneOfProps.put(ONE_OF_KEY, (Object)choiceProps);
        oneOfProps.put(TYPE_KEY, (Object)OBJECT_TYPE);
        return oneOfProps;
    }

    private void processConstraints(ConstraintDefinition constraints, JSONObject props) throws JSONException {
        boolean isMandatory = constraints.isMandatory();
        props.put(REQUIRED_KEY, isMandatory);
        Integer minElements = constraints.getMinElements();
        Integer maxElements = constraints.getMaxElements();
        if (minElements != null) {
            props.put(MIN_ITEMS, (Object)minElements);
        }
        if (maxElements != null) {
            props.put(MAX_ITEMS, (Object)maxElements);
        }
    }

    private JSONObject processLeafNode(LeafSchemaNode leafNode) throws JSONException {
        JSONObject property = new JSONObject();
        String leafDescription = leafNode.getDescription();
        property.put(DESCRIPTION_KEY, (Object)leafDescription);
        this.processConstraints(leafNode.getConstraints(), property);
        this.processTypeDef(leafNode.getType(), property);
        return property;
    }

    private JSONObject processAnyXMLNode(AnyXmlSchemaNode leafNode) throws JSONException {
        JSONObject property = new JSONObject();
        String leafDescription = leafNode.getDescription();
        property.put(DESCRIPTION_KEY, (Object)leafDescription);
        this.processConstraints(leafNode.getConstraints(), property);
        return property;
    }

    private void processTypeDef(TypeDefinition<?> leafTypeDef, JSONObject property) throws JSONException {
        if (leafTypeDef instanceof ExtendedType) {
            this.processExtendedType(leafTypeDef, property);
        } else if (leafTypeDef instanceof EnumerationType) {
            this.processEnumType((EnumerationType)leafTypeDef, property);
        } else if (leafTypeDef instanceof BitsTypeDefinition) {
            this.processBitsType((BitsTypeDefinition)leafTypeDef, property);
        } else if (leafTypeDef instanceof UnionTypeDefinition) {
            this.processUnionType((UnionTypeDefinition)leafTypeDef, property);
        } else if (leafTypeDef instanceof IdentityrefTypeDefinition) {
            property.putOpt(TYPE_KEY, (Object)((IdentityrefTypeDefinition)leafTypeDef).getIdentity().getQName().getLocalName());
        } else if (leafTypeDef instanceof BinaryTypeDefinition) {
            this.processBinaryType((BinaryTypeDefinition)leafTypeDef, property);
        } else {
            String jsonType = YANG_TYPE_TO_JSON_TYPE_MAPPING.get(leafTypeDef.getClass());
            if (jsonType == null) {
                jsonType = OBJECT_TYPE;
            }
            property.putOpt(TYPE_KEY, (Object)jsonType);
        }
    }

    private void processExtendedType(TypeDefinition<?> leafTypeDef, JSONObject property) throws JSONException {
        TypeDefinition leafBaseType = leafTypeDef.getBaseType();
        if (leafBaseType instanceof ExtendedType) {
            this.processExtendedType(leafBaseType, property);
        } else {
            List lengthConstraints = ((ExtendedType)leafTypeDef).getLengthConstraints();
            for (LengthConstraint lengthConstraint : lengthConstraints) {
                Number min = lengthConstraint.getMin();
                Number max = lengthConstraint.getMax();
                property.putOpt(MIN_LENGTH_KEY, (Object)min);
                property.putOpt(MAX_LENGTH_KEY, (Object)max);
            }
            String jsonType = YANG_TYPE_TO_JSON_TYPE_MAPPING.get(leafBaseType.getClass());
            property.putOpt(TYPE_KEY, (Object)jsonType);
        }
    }

    private void processBinaryType(BinaryTypeDefinition binaryType, JSONObject property) throws JSONException {
        property.put(TYPE_KEY, (Object)STRING);
        JSONObject media = new JSONObject();
        media.put(BINARY_ENCODING_KEY, (Object)BASE_64);
        property.put(MEDIA_KEY, (Object)media);
    }

    private void processEnumType(EnumerationType enumLeafType, JSONObject property) throws JSONException {
        List enumPairs = enumLeafType.getValues();
        ArrayList<String> enumNames = new ArrayList<String>();
        for (EnumTypeDefinition.EnumPair enumPair : enumPairs) {
            enumNames.add(enumPair.getName());
        }
        property.putOpt(ENUM, (Object)new JSONArray(enumNames));
    }

    private void processBitsType(BitsTypeDefinition bitsType, JSONObject property) throws JSONException {
        property.put(TYPE_KEY, (Object)ARRAY_TYPE);
        property.put(MIN_ITEMS, 0);
        property.put(UNIQUE_ITEMS_KEY, true);
        JSONArray enumValues = new JSONArray();
        List bits = bitsType.getBits();
        for (BitsTypeDefinition.Bit bit : bits) {
            enumValues.put((Object)bit.getName());
        }
        JSONObject itemsValue = new JSONObject();
        itemsValue.put(ENUM, (Object)enumValues);
        property.put(ITEMS_KEY, (Object)itemsValue);
    }

    private void processUnionType(UnionTypeDefinition unionType, JSONObject property) throws JSONException {
        StringBuilder type = new StringBuilder();
        for (TypeDefinition typeDef : unionType.getTypes()) {
            if (type.length() > 0) {
                type.append(" or ");
            }
            type.append(YANG_TYPE_TO_JSON_TYPE_MAPPING.get(typeDef.getClass()));
        }
        property.put(TYPE_KEY, (Object)type);
    }

    private JSONObject getSchemaTemplate() throws JSONException {
        JSONObject schemaJSON = new JSONObject();
        schemaJSON.put(SCHEMA_KEY, (Object)SCHEMA_URL);
        return schemaJSON;
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put(StringType.class, (Object)STRING);
        b.put(BooleanType.class, (Object)BOOLEAN);
        b.put(Int8.class, (Object)INTEGER);
        b.put(Int16.class, (Object)INTEGER);
        b.put(Int32.class, (Object)INTEGER);
        b.put(Int64.class, (Object)INTEGER);
        b.put(Uint16.class, (Object)INTEGER);
        b.put(Uint32.class, (Object)INTEGER);
        b.put(Uint64.class, (Object)INTEGER);
        b.put(Uint8.class, (Object)INTEGER);
        b.put(Decimal64.class, (Object)NUMBER);
        b.put(EnumerationType.class, (Object)ENUM);
        YANG_TYPE_TO_JSON_TYPE_MAPPING = b.build();
    }
}

