/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.doc.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.sal.rest.doc.swagger.Operation;
import org.opendaylight.controller.sal.rest.doc.swagger.Parameter;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public final class OperationBuilder {
    public static final String OPERATIONAL = "(operational)";
    public static final String CONFIG = "(config)";
    public static final List<String> CONSUMES_PUT_POST = new ArrayList<String>();

    static {
        CONSUMES_PUT_POST.add("application/json");
        CONSUMES_PUT_POST.add("application/xml");
    }

    public static final class Delete
    extends Get {
        private static final String METHOD_NAME = "DELETE";

        public Delete(DataSchemaNode node) {
            super(node, false);
        }

        @Override
        public Operation build() {
            this.spec.setMethod(METHOD_NAME);
            this.spec.setNickname("DELETE-" + this.schemaNode.getQName().getLocalName());
            this.spec.setType(null);
            return this.spec;
        }
    }

    public static final class Post
    extends Put {
        public static final String METHOD_NAME = "POST";
        private final DataNodeContainer dataNodeContainer;

        public Post(String nodeName, String description, DataNodeContainer dataNodeContainer) {
            super(nodeName, description);
            this.dataNodeContainer = dataNodeContainer;
            this.spec.setType(OperationBuilder.CONFIG + nodeName + METHOD_NAME);
            this.spec.setConsumes(CONSUMES_PUT_POST);
        }

        @Override
        public Operation build() {
            this.spec.setMethod(METHOD_NAME);
            this.spec.setNickname("POST-" + this.nodeName);
            return this.spec;
        }

        @Override
        public Put pathParams(List<Parameter> params) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(params);
            for (DataSchemaNode node : this.dataNodeContainer.getChildNodes()) {
                if (!(node instanceof ListSchemaNode) && !(node instanceof ContainerSchemaNode)) continue;
                Parameter payload = new Parameter();
                payload.setParamType("body");
                payload.setType(OperationBuilder.CONFIG + node.getQName().getLocalName());
                payload.setName("**(config)" + node.getQName().getLocalName());
                parameters.add(payload);
            }
            this.spec.setParameters(parameters);
            return this;
        }

        public Post summary(String summary) {
            this.spec.setSummary(summary);
            return this;
        }
    }

    public static class Put {
        protected Operation spec;
        protected String nodeName;
        private static final String METHOD_NAME = "PUT";

        public Put(String nodeName, String description) {
            this.nodeName = nodeName;
            this.spec = new Operation();
            this.spec.setType(OperationBuilder.CONFIG + nodeName);
            this.spec.setNotes(description);
            this.spec.setConsumes(CONSUMES_PUT_POST);
        }

        public Put pathParams(List<Parameter> params) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(params);
            Parameter payload = new Parameter();
            payload.setParamType("body");
            payload.setType(OperationBuilder.CONFIG + this.nodeName);
            parameters.add(payload);
            this.spec.setParameters(parameters);
            return this;
        }

        public Operation build() {
            this.spec.setMethod(METHOD_NAME);
            this.spec.setNickname("PUT-" + this.nodeName);
            return this.spec;
        }
    }

    public static class Get {
        protected Operation spec;
        protected DataSchemaNode schemaNode;
        private static final String METHOD_NAME = "GET";

        public Get(DataSchemaNode node, boolean isConfig) {
            this.schemaNode = node;
            this.spec = new Operation();
            this.spec.setMethod(METHOD_NAME);
            this.spec.setNickname("GET-" + node.getQName().getLocalName());
            this.spec.setType((isConfig ? OperationBuilder.CONFIG : OperationBuilder.OPERATIONAL) + node.getQName().getLocalName());
            this.spec.setNotes(node.getDescription());
        }

        public Get pathParams(List<Parameter> params) {
            ArrayList<Parameter> pathParameters = new ArrayList<Parameter>(params);
            this.spec.setParameters(pathParameters);
            return this;
        }

        public Operation build() {
            return this.spec;
        }
    }
}

