/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.rest.doc.util;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public class RestDocgenUtil {
    private static Map<URI, Map<Date, Module>> namespaceAndRevisionToModule = new HashMap<URI, Map<Date, Module>>();

    private RestDocgenUtil() {
    }

    public static String resolvePathArgumentsName(SchemaNode node, SchemaContext schemaContext) {
        Iterable schemaPath = node.getPath().getPathTowardsRoot();
        Iterator it = schemaPath.iterator();
        QName nodeQName = (QName)it.next();
        QName parentQName = null;
        if (it.hasNext()) {
            parentQName = (QName)it.next();
        }
        if (RestDocgenUtil.isEqualNamespaceAndRevision(parentQName, nodeQName)) {
            return node.getQName().getLocalName();
        }
        return RestDocgenUtil.resolveFullNameFromNode(node, schemaContext);
    }

    private static synchronized String resolveFullNameFromNode(SchemaNode node, SchemaContext schemaContext) {
        Module module;
        URI namespace = node.getQName().getNamespace();
        Date revision = node.getQName().getRevision();
        Map<Date, Module> revisionToModule = namespaceAndRevisionToModule.get(namespace);
        if (revisionToModule == null) {
            revisionToModule = new HashMap<Date, Module>();
            namespaceAndRevisionToModule.put(namespace, revisionToModule);
        }
        if ((module = revisionToModule.get(revision)) == null) {
            module = schemaContext.findModuleByNamespaceAndRevision(namespace, revision);
            revisionToModule.put(revision, module);
        }
        if (module != null) {
            return module.getName() + ":" + node.getQName().getLocalName();
        }
        return node.getQName().getLocalName();
    }

    public static String resolveNodesName(SchemaNode node, Module module, SchemaContext schemaContext) {
        if (node.getQName().getNamespace().equals(module.getQNameModule().getNamespace()) && node.getQName().getRevision().equals(module.getQNameModule().getRevision())) {
            return node.getQName().getLocalName();
        }
        return RestDocgenUtil.resolveFullNameFromNode(node, schemaContext);
    }

    private static boolean isEqualNamespaceAndRevision(QName parentQName, QName nodeQName) {
        if (parentQName == null) {
            return nodeQName == null;
        }
        return parentQName.getNamespace().equals(nodeQName.getNamespace()) && parentQName.getRevision().equals(nodeQName.getRevision());
    }
}

