/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.test.model.util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeLeafOnlyUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeLeafOnlyUsesAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUses;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUsesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedListKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class ListsBindingUtils {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    public static final TopLevelListKey TOP_FOO_KEY = new TopLevelListKey("foo");
    public static final TopLevelListKey TOP_BAR_KEY = new TopLevelListKey("bar");
    public static final ListViaUsesKey USES_ONE_KEY = new ListViaUsesKey("one");
    public static final ListViaUsesKey USES_TWO_KEY = new ListViaUsesKey("two");

    private ListsBindingUtils() {
        throw new UnsupportedOperationException();
    }

    public static InstanceIdentifier<TopLevelList> path(TopLevelListKey key) {
        return TOP_PATH.child(TopLevelList.class, (Identifier)key);
    }

    public static InstanceIdentifier<NestedList> path(TopLevelListKey top, NestedListKey nested) {
        return ListsBindingUtils.path(top).child(NestedList.class, (Identifier)nested);
    }

    public static InstanceIdentifier<ListViaUses> path(TopLevelListKey top, ListViaUsesKey uses) {
        return ListsBindingUtils.path(top).augmentation(TreeComplexUsesAugment.class).child(ListViaUses.class, (Identifier)uses);
    }

    public static <T extends DataObject & Augmentation<TopLevelList>> InstanceIdentifier<T> path(TopLevelListKey key, Class<T> augmentation) {
        return ListsBindingUtils.path(key).augmentation(augmentation);
    }

    public static Top top(TopLevelList ... listItems) {
        return new TopBuilder().setTopLevelList(Arrays.asList(listItems)).build();
    }

    public static TopLevelList topLevelList(TopLevelListKey key) {
        return new TopLevelListBuilder().setKey(key).build();
    }

    public static TopLevelList topLevelList(TopLevelListKey key, TreeComplexUsesAugment augment) {
        TopLevelListBuilder builder = new TopLevelListBuilder().setKey(key);
        builder.addAugmentation(TreeComplexUsesAugment.class, augment);
        return builder.build();
    }

    public static TreeComplexUsesAugment complexUsesAugment(ListViaUsesKey ... keys) {
        ImmutableList.Builder listViaUses = ImmutableList.builder();
        for (ListViaUsesKey key : keys) {
            listViaUses.add((Object)new ListViaUsesBuilder().setKey(key).build());
        }
        return new TreeComplexUsesAugmentBuilder().setListViaUses((List<ListViaUses>)listViaUses.build()).build();
    }

    public static TreeLeafOnlyUsesAugment leafOnlyUsesAugment(String leafFromGroupingValue) {
        return new TreeLeafOnlyUsesAugmentBuilder().setLeafFromGrouping(leafFromGroupingValue).build();
    }
}

