/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedListKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NestedListBuilder
implements Builder<NestedList> {
    private NestedListKey _key;
    private String _name;
    private String _type;
    Map<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>> augmentation = Collections.emptyMap();

    public NestedListBuilder() {
    }

    public NestedListBuilder(NestedList base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NestedListKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._type = base.getType();
        if (base instanceof NestedListImpl) {
            NestedListImpl impl = (NestedListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>>(casted.augmentations());
        }
    }

    public NestedListKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public <E extends Augmentation<NestedList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NestedListBuilder setKey(NestedListKey value) {
        this._key = value;
        return this;
    }

    public NestedListBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public NestedListBuilder setType(String value) {
        this._type = value;
        return this;
    }

    public NestedListBuilder addAugmentation(Class<? extends Augmentation<NestedList>> augmentationType, Augmentation<NestedList> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NestedListBuilder removeAugmentation(Class<? extends Augmentation<NestedList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NestedList build() {
        return new NestedListImpl(this);
    }

    private static final class NestedListImpl
    implements NestedList {
        private final NestedListKey _key;
        private final String _name;
        private final String _type;
        private Map<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NestedList> getImplementedInterface() {
            return NestedList.class;
        }

        private NestedListImpl(NestedListBuilder base) {
            if (base.getKey() == null) {
                this._key = new NestedListKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>>(base.augmentation);
                }
            }
        }

        @Override
        public NestedListKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getType() {
            return this._type;
        }

        public <E extends Augmentation<NestedList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NestedList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NestedList other = (NestedList)obj;
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._type == null ? other.getType() != null : !this._type.equals(other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NestedListImpl otherImpl = (NestedListImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NestedList>>, Augmentation<NestedList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NestedList [");
            boolean first = true;
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append(this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

