/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.OrderedContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container.OrderedList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OrderedContainerBuilder
implements Builder<OrderedContainer> {
    private List<OrderedList> _orderedList;
    Map<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>> augmentation = Collections.emptyMap();

    public OrderedContainerBuilder() {
    }

    public OrderedContainerBuilder(OrderedContainer base) {
        AugmentationHolder casted;
        this._orderedList = base.getOrderedList();
        if (base instanceof OrderedContainerImpl) {
            OrderedContainerImpl impl = (OrderedContainerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>>(casted.augmentations());
        }
    }

    public List<OrderedList> getOrderedList() {
        return this._orderedList;
    }

    public <E extends Augmentation<OrderedContainer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OrderedContainerBuilder setOrderedList(List<OrderedList> value) {
        this._orderedList = value;
        return this;
    }

    public OrderedContainerBuilder addAugmentation(Class<? extends Augmentation<OrderedContainer>> augmentationType, Augmentation<OrderedContainer> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OrderedContainerBuilder removeAugmentation(Class<? extends Augmentation<OrderedContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OrderedContainer build() {
        return new OrderedContainerImpl(this);
    }

    private static final class OrderedContainerImpl
    implements OrderedContainer {
        private final List<OrderedList> _orderedList;
        private Map<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OrderedContainer> getImplementedInterface() {
            return OrderedContainer.class;
        }

        private OrderedContainerImpl(OrderedContainerBuilder base) {
            this._orderedList = base.getOrderedList();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>>(base.augmentation);
                }
            }
        }

        @Override
        public List<OrderedList> getOrderedList() {
            return this._orderedList;
        }

        public <E extends Augmentation<OrderedContainer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._orderedList == null ? 0 : this._orderedList.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OrderedContainer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OrderedContainer other = (OrderedContainer)obj;
            if (this._orderedList == null ? other.getOrderedList() != null : !this._orderedList.equals(other.getOrderedList())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OrderedContainerImpl otherImpl = (OrderedContainerImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OrderedContainer>>, Augmentation<OrderedContainer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OrderedContainer [");
            boolean first = true;
            if (this._orderedList != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_orderedList=");
                builder.append(this._orderedList);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

