/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.NameValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container.OrderedList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container.OrderedListKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OrderedListBuilder
implements Builder<OrderedList> {
    private OrderedListKey _key;
    private String _name;
    private String _value;
    Map<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>> augmentation = Collections.emptyMap();

    public OrderedListBuilder() {
    }

    public OrderedListBuilder(NameValue arg) {
        this._name = arg.getName();
        this._value = arg.getValue();
    }

    public OrderedListBuilder(OrderedList base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new OrderedListKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._value = base.getValue();
        if (base instanceof OrderedListImpl) {
            OrderedListImpl impl = (OrderedListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NameValue) {
            this._name = ((NameValue)arg).getName();
            this._value = ((NameValue)arg).getValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.NameValue] \nbut was: " + arg);
        }
    }

    public OrderedListKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public <E extends Augmentation<OrderedList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OrderedListBuilder setKey(OrderedListKey value) {
        this._key = value;
        return this;
    }

    public OrderedListBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public OrderedListBuilder setValue(String value) {
        this._value = value;
        return this;
    }

    public OrderedListBuilder addAugmentation(Class<? extends Augmentation<OrderedList>> augmentationType, Augmentation<OrderedList> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OrderedListBuilder removeAugmentation(Class<? extends Augmentation<OrderedList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OrderedList build() {
        return new OrderedListImpl(this);
    }

    private static final class OrderedListImpl
    implements OrderedList {
        private final OrderedListKey _key;
        private final String _name;
        private final String _value;
        private Map<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OrderedList> getImplementedInterface() {
            return OrderedList.class;
        }

        private OrderedListImpl(OrderedListBuilder base) {
            if (base.getKey() == null) {
                this._key = new OrderedListKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>>(base.augmentation);
                }
            }
        }

        @Override
        public OrderedListKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        public <E extends Augmentation<OrderedList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OrderedList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OrderedList other = (OrderedList)obj;
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._value == null ? other.getValue() != null : !this._value.equals(other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OrderedListImpl otherImpl = (OrderedListImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OrderedList>>, Augmentation<OrderedList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OrderedList [");
            boolean first = true;
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

