package org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.Fooroot;
import java.util.Objects;
import java.util.List;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root} instances.
 *
 * @see org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root
 *
 */
public class RootBuilder implements Builder<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root> {

    private List<Fooroot> _fooroot;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>>, Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> augmentation = Collections.emptyMap();

    public RootBuilder() {
    }

    public RootBuilder(Root base) {
        this._fooroot = base.getFooroot();
        if (base instanceof RootImpl) {
            RootImpl impl = (RootImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public List<Fooroot> getFooroot() {
        return _fooroot;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public RootBuilder setFooroot(final List<Fooroot> value) {
        this._fooroot = value;
        return this;
    }
    
    public RootBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RootBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Root build() {
        return new RootImpl(this);
    }

    private static final class RootImpl implements Root {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root.class;
        }

        private final List<Fooroot> _fooroot;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>>, Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> augmentation = Collections.emptyMap();

        private RootImpl(RootBuilder base) {
            this._fooroot = base.getFooroot();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>>, Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>>, Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public List<Fooroot> getFooroot() {
            return _fooroot;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_fooroot);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root other = (org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root)obj;
            if (!Objects.equals(_fooroot, other.getFooroot())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RootImpl otherImpl = (RootImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>>, Augmentation<org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Root [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_fooroot != null) {
                builder.append("_fooroot=");
                builder.append(_fooroot);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
