package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.Root;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-test-bug-3090</b>
 * <pre>
 * list list-in-root {
 *     key "leaf-c" "leaf-a" "leaf-b";
 *     leaf leaf-a {
 *         type string;
 *     }
 *     leaf leaf-b {
 *         type string;
 *     }
 *     leaf leaf-c {
 *         type string;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-test-bug-3090/root/list-in-root</i>
 *
 * <p>To create instances of this class use {@link ListInRootBuilder}.
 * @see ListInRootBuilder
 * @see ListInRootKey
 *
 */
public interface ListInRoot
    extends
    ChildOf<Root>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot>,
    Identifiable<ListInRootKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:opendaylight-test-bug-3090",
        "2016-01-01", "list-in-root").intern();

    /**
     * @return <code>java.lang.String</code> <code>leafA</code>, or <code>null</code> if not present
     */
    java.lang.String getLeafA();
    
    /**
     * @return <code>java.lang.String</code> <code>leafB</code>, or <code>null</code> if not present
     */
    java.lang.String getLeafB();
    
    /**
     * @return <code>java.lang.String</code> <code>leafC</code>, or <code>null</code> if not present
     */
    java.lang.String getLeafC();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRootKey</code> <code>key</code>, or <code>null</code> if not present
     */
    ListInRootKey getKey();

}

