package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;

public enum CustomEnum {
    Type1(0, "type1"),
    
    Type2(1, "type2"),
    
    Type3(2, "type3")
    ;

    private static final java.util.Map<java.lang.Integer, CustomEnum> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, CustomEnum> b = com.google.common.collect.ImmutableMap.builder();
        for (CustomEnum enumItem : CustomEnum.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private CustomEnum(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding CustomEnum item
     */
    public static CustomEnum forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
