package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;
import javax.annotation.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>opendaylight-of-migration-test-model</b>
 * <pre>
 * rpc knock-knock {
 *     input {
 *         leaf knocker-id {
 *             type instance-identifier;
 *         }
 *         leaf question {
 *             type string;
 *         }
 *     }
 *     
 *     output {
 *         leaf answer {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface OpendaylightOfMigrationTestModelService
    extends
    RpcService
{




    @CheckReturnValue
    Future<RpcResult<KnockKnockOutput>> knockKnock(KnockKnockInput input);

}

