package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.list1.List12;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.list1.List11;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.AugGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-of-migration-test-model</b>
 * <pre>
 * list list1 {
 *     key "attr-str";
 *     leaf attr-str {
 *         type string;
 *     }
 *     list list1-1 {
 *         key "attr-int";
 *         leaf attr-int {
 *             type int32;
 *         }
 *         leaf attr-str {
 *             type string;
 *         }
 *         leaf flags {
 *             type bit-flags;
 *         }
 *     }
 *     list list1-2 {
 *         key "attr-int";
 *         leaf attr-int {
 *             type int32;
 *         }
 *         leaf attr-str {
 *             type string;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-of-migration-test-model/aug-grouping/list1</i>
 *
 * <p>To create instances of this class use {@link List1Builder}.
 * @see List1Builder
 * @see List1Key
 *
 */
public interface List1
    extends
    ChildOf<AugGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.List1>,
    Identifiable<List1Key>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:of-migration-test-model",
        "2015-02-10", "list1").intern();

    /**
     * @return <code>java.lang.String</code> <code>attrStr</code>, or <code>null</code> if not present
     */
    java.lang.String getAttrStr();
    
    /**
     * @return <code>java.util.List</code> <code>list11</code>, or <code>null</code> if not present
     */
    List<List11> getList11();
    
    /**
     * @return <code>java.util.List</code> <code>list12</code>, or <code>null</code> if not present
     */
    List<List12> getList12();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.List1Key</code> <code>key</code>, or <code>null</code> if not present
     */
    List1Key getKey();

}

