package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUses;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ContainerWithUses;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment
 *
 */
public class TreeComplexUsesAugmentBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment> {

    private ContainerWithUses _containerWithUses;
    private List<ListViaUses> _listViaUses;


    public TreeComplexUsesAugmentBuilder() {
    }
    public TreeComplexUsesAugmentBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping arg) {
        this._containerWithUses = arg.getContainerWithUses();
        this._listViaUses = arg.getListViaUses();
    }

    public TreeComplexUsesAugmentBuilder(TreeComplexUsesAugment base) {
        this._containerWithUses = base.getContainerWithUses();
        this._listViaUses = base.getListViaUses();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping) {
            this._containerWithUses = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping)arg).getContainerWithUses();
            this._listViaUses = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping)arg).getListViaUses();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping] \n" +
              "but was: " + arg
            );
        }
    }

    public ContainerWithUses getContainerWithUses() {
        return _containerWithUses;
    }
    
    public List<ListViaUses> getListViaUses() {
        return _listViaUses;
    }

     
    public TreeComplexUsesAugmentBuilder setContainerWithUses(final ContainerWithUses value) {
        this._containerWithUses = value;
        return this;
    }
    
     
    public TreeComplexUsesAugmentBuilder setListViaUses(final List<ListViaUses> value) {
        this._listViaUses = value;
        return this;
    }

    @Override
    public TreeComplexUsesAugment build() {
        return new TreeComplexUsesAugmentImpl(this);
    }

    private static final class TreeComplexUsesAugmentImpl implements TreeComplexUsesAugment {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment.class;
        }

        private final ContainerWithUses _containerWithUses;
        private final List<ListViaUses> _listViaUses;


        private TreeComplexUsesAugmentImpl(TreeComplexUsesAugmentBuilder base) {
            this._containerWithUses = base.getContainerWithUses();
            this._listViaUses = base.getListViaUses();
        }

        @Override
        public ContainerWithUses getContainerWithUses() {
            return _containerWithUses;
        }
        
        @Override
        public List<ListViaUses> getListViaUses() {
            return _listViaUses;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_containerWithUses);
            result = prime * result + Objects.hashCode(_listViaUses);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment)obj;
            if (!Objects.equals(_containerWithUses, other.getContainerWithUses())) {
                return false;
            }
            if (!Objects.equals(_listViaUses, other.getListViaUses())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "TreeComplexUsesAugment [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_containerWithUses != null) {
                builder.append("_containerWithUses=");
                builder.append(_containerWithUses);
                builder.append(", ");
            }
            if (_listViaUses != null) {
                builder.append("_listViaUses=");
                builder.append(_listViaUses);
            }
            return builder.append(']').toString();
        }
    }

}
