package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for receiving the following YANG notifications defined in module <b>opendaylight-test-notification</b>
 * <pre>
 * notification out-of-pixie-dust-notification {
 *     description
 *         "Just a testing notification that we can not fly for now.";
 *     leaf reason {
 *         type string;
 *     }
 *     leaf days-till-new-dust {
 *         type uint16;
 *     }
 * }
 * </pre>
 *
 */
public interface OpendaylightTestNotificationListener
    extends
    NotificationListener
{




    /**
     * Just a testing notification that we can not fly for now.
     *
     */
    void onOutOfPixieDustNotification(OutOfPixieDustNotification notification);

}

