package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * Just a testing notification that we can not fly for now.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-test-notification</b>
 * <pre>
 * notification out-of-pixie-dust-notification {
 *     description
 *         "Just a testing notification that we can not fly for now.";
 *     leaf reason {
 *         type string;
 *     }
 *     leaf days-till-new-dust {
 *         type uint16;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-test-notification/out-of-pixie-dust-notification</i>
 *
 * <p>To create instances of this class use {@link OutOfPixieDustNotificationBuilder}.
 * @see OutOfPixieDustNotificationBuilder
 *
 */
public interface OutOfPixieDustNotification
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.notification.rev150205.OutOfPixieDustNotification>,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:bi:ba:notification",
        "2015-02-05", "out-of-pixie-dust-notification").intern();

    /**
     * @return <code>java.lang.String</code> <code>reason</code>, or <code>null</code> if not present
     */
    java.lang.String getReason();
    
    /**
     * @return <code>java.lang.Integer</code> <code>daysTillNewDust</code>, or <code>null</code> if not present
     */
    java.lang.Integer getDaysTillNewDust();

}

