package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for receiving the following YANG notifications defined in module <b>opendaylight-mdsal-list-test</b>
 * <pre>
 * notification two-level-list-changed {
 *     list top-level-list {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *         list nested-list {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *             leaf type {
 *                 type string;
 *             }
 *         }
 *     }
 *     uses two-level-list;
 * }
 * </pre>
 *
 */
public interface OpendaylightMdsalListTestListener
    extends
    NotificationListener
{




    void onTwoLevelListChanged(TwoLevelListChanged notification);

}

