package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701;
import javax.annotation.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>opendaylight-mdsal-list-test</b>
 * <pre>
 * rpc put-top {
 *     input {
 *         list top-level-list {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *             list nested-list {
 *                 key "name";
 *                 leaf name {
 *                     type string;
 *                 }
 *                 leaf type {
 *                     type string;
 *                 }
 *             }
 *             leaf second-simple-value {
 *                 type string;
 *             }
 *             leaf simple-value {
 *                 type string;
 *             }
 *             leaf leaf-from-grouping {
 *                 type string;
 *             }
 *             container container-with-uses {
 *                 leaf leaf-from-grouping {
 *                     type string;
 *                 }
 *                 uses leaf-from-grouping;
 *             }
 *             list list-via-uses {
 *                 key "name";
 *                 leaf name {
 *                     type string;
 *                 }
 *             }
 *             augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *                 when "Optional.empty";
 *                 status CURRENT;
 *                 leaf second-simple-value {
 *                     type string;
 *                 }
 *             }
 *             augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *                 when "Optional.empty";
 *                 status CURRENT;
 *                 leaf simple-value {
 *                     type string;
 *                 }
 *             }
 *             augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *                 when "Optional.empty";
 *                 status CURRENT;
 *                 leaf leaf-from-grouping {
 *                     type string;
 *                 }
 *                 uses leaf-from-grouping;
 *             }
 *             augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *                 when "Optional.empty";
 *                 status CURRENT;
 *                 container container-with-uses {
 *                     leaf leaf-from-grouping {
 *                         type string;
 *                     }
 *                     uses leaf-from-grouping;
 *                 }
 *                 list list-via-uses {
 *                     key "name";
 *                     leaf name {
 *                         type string;
 *                     }
 *                 }
 *                 uses complex-from-grouping;
 *             }
 *         }
 *     }
 *     
 *     output {
 *     }
 * }
 * </pre>
 *
 */
public interface OpendaylightMdsalListTestService
    extends
    RpcService
{




    @CheckReturnValue
    Future<RpcResult<java.lang.Void>> putTop(PutTopInput input);

}

