package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-mdsal-list-test</b>
 * <pre>
 * container input {
 *     list top-level-list {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *         list nested-list {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *             leaf type {
 *                 type string;
 *             }
 *         }
 *         leaf second-simple-value {
 *             type string;
 *         }
 *         leaf simple-value {
 *             type string;
 *         }
 *         leaf leaf-from-grouping {
 *             type string;
 *         }
 *         container container-with-uses {
 *             leaf leaf-from-grouping {
 *                 type string;
 *             }
 *             uses leaf-from-grouping;
 *         }
 *         list list-via-uses {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *         }
 *         augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *             when "Optional.empty";
 *             status CURRENT;
 *             leaf second-simple-value {
 *                 type string;
 *             }
 *         }
 *         augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *             when "Optional.empty";
 *             status CURRENT;
 *             leaf simple-value {
 *                 type string;
 *             }
 *         }
 *         augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *             when "Optional.empty";
 *             status CURRENT;
 *             leaf leaf-from-grouping {
 *                 type string;
 *             }
 *             uses leaf-from-grouping;
 *         }
 *         augment \(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)put-top\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)input\(urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list)top-level-list {
 *             when "Optional.empty";
 *             status CURRENT;
 *             container container-with-uses {
 *                 leaf leaf-from-grouping {
 *                     type string;
 *                 }
 *                 uses leaf-from-grouping;
 *             }
 *             list list-via-uses {
 *                 key "name";
 *                 leaf name {
 *                     type string;
 *                 }
 *             }
 *             uses complex-from-grouping;
 *         }
 *     }
 *     uses two-level-list;
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-mdsal-list-test/put-top/input</i>
 *
 * <p>To create instances of this class use {@link PutTopInputBuilder}.
 * @see PutTopInputBuilder
 *
 */
public interface PutTopInput
    extends
    TwoLevelList,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.PutTopInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list",
        "2014-07-01", "input").intern();


}

