package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import java.util.List;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-mdsal-list-test</b>
 * <pre>
 * grouping two-level-list {
 *     list top-level-list {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *         list nested-list {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *             leaf type {
 *                 type string;
 *             }
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-mdsal-list-test/two-level-list</i>
 *
 */
public interface TwoLevelList
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list",
        "2014-07-01", "two-level-list").intern();

    /**
     * Top Level List
     *
     *
     *
     * @return <code>java.util.List</code> <code>topLevelList</code>, or <code>null</code> if not present
     */
    List<TopLevelList> getTopLevelList();

}

