package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-mdsal-list-test</b>
 * <pre>
 * notification two-level-list-changed {
 *     list top-level-list {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *         list nested-list {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *             leaf type {
 *                 type string;
 *             }
 *         }
 *     }
 *     uses two-level-list;
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-mdsal-list-test/two-level-list-changed</i>
 *
 * <p>To create instances of this class use {@link TwoLevelListChangedBuilder}.
 * @see TwoLevelListChangedBuilder
 *
 */
public interface TwoLevelListChanged
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TwoLevelListChanged>,
    TwoLevelList,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list",
        "2014-07-01", "two-level-list-changed").intern();


}

