package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TwoLevelList;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedList;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * Top Level List
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-mdsal-list-test</b>
 * <pre>
 * list top-level-list {
 *     key "name";
 *     leaf name {
 *         type string;
 *     }
 *     list nested-list {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *         leaf type {
 *             type string;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-mdsal-list-test/two-level-list/top-level-list</i>
 *
 * <p>To create instances of this class use {@link TopLevelListBuilder}.
 * @see TopLevelListBuilder
 * @see TopLevelListKey
 *
 */
public interface TopLevelList
    extends
    ChildOf<TwoLevelList>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList>,
    Identifiable<TopLevelListKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list",
        "2014-07-01", "top-level-list").intern();

    /**
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    java.lang.String getName();
    
    /**
     * A list of service functions that compose the service chain
     *
     *
     *
     * @return <code>java.util.List</code> <code>nestedList</code>, or <code>null</code> if not present
     */
    List<NestedList> getNestedList();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey</code> <code>key</code>, or <code>null</code> if not present
     */
    TopLevelListKey getKey();

}

