package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * A list of service functions that compose the service chain
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-mdsal-list-test</b>
 * <pre>
 * list nested-list {
 *     key "name";
 *     leaf name {
 *         type string;
 *     }
 *     leaf type {
 *         type string;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-mdsal-list-test/two-level-list/top-level-list/nested-list</i>
 *
 * <p>To create instances of this class use {@link NestedListBuilder}.
 * @see NestedListBuilder
 * @see NestedListKey
 *
 */
public interface NestedList
    extends
    ChildOf<TopLevelList>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedList>,
    Identifiable<NestedListKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:list",
        "2014-07-01", "nested-list").intern();

    /**
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    java.lang.String getName();
    
    /**
     * @return <code>java.lang.String</code> <code>type</code>, or <code>null</code> if not present
     */
    java.lang.String getType();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedListKey</code> <code>key</code>, or <code>null</code> if not present
     */
    NestedListKey getKey();

}

