package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>listener-container</b>
 * <pre>
 * container listener-test {
 *     list list-item {
 *         key "sip" "op";
 *         leaf sip {
 *             type string;
 *         }
 *         leaf op {
 *             type uint32;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>listener-container/listener-test</i>
 *
 * <p>To create instances of this class use {@link ListenerTestBuilder}.
 * @see ListenerTestBuilder
 *
 */
public interface ListenerTest
    extends
    ChildOf<ListenerContainerData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.ListenerTest>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:listener",
        "2015-08-25", "listener-test").intern();

    /**
     * @return <code>java.util.List</code> <code>listItem</code>, or <code>null</code> if not present
     */
    List<ListItem> getListItem();

}

