package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.ListenerTest;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>listener-container</b>
 * <pre>
 * list list-item {
 *     key "sip" "op";
 *     leaf sip {
 *         type string;
 *     }
 *     leaf op {
 *         type uint32;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>listener-container/listener-test/list-item</i>
 *
 * <p>To create instances of this class use {@link ListItemBuilder}.
 * @see ListItemBuilder
 * @see ListItemKey
 *
 */
public interface ListItem
    extends
    ChildOf<ListenerTest>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem>,
    Identifiable<ListItemKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:listener",
        "2015-08-25", "list-item").intern();

    /**
     * @return <code>java.lang.String</code> <code>sip</code>, or <code>null</code> if not present
     */
    java.lang.String getSip();
    
    /**
     * @return <code>java.lang.Long</code> <code>op</code>, or <code>null</code> if not present
     */
    java.lang.Long getOp();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItemKey</code> <code>key</code>, or <code>null</code> if not present
     */
    ListItemKey getKey();

}

