package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.Lists;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container.OrderedList;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-sal-test-store</b>
 * <pre>
 * container ordered-container {
 *     list ordered-list {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *         leaf value {
 *             type string;
 *         }
 *         uses name-value;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-sal-test-store/lists/ordered-container</i>
 *
 * <p>To create instances of this class use {@link OrderedContainerBuilder}.
 * @see OrderedContainerBuilder
 *
 */
public interface OrderedContainer
    extends
    ChildOf<Lists>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.OrderedContainer>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:store",
        "2014-04-22", "ordered-container").intern();

    /**
     * @return <code>java.util.List</code> <code>orderedList</code>, or <code>null</code> if not present
     */
    List<OrderedList> getOrderedList();

}

