package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.Lists;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.unordered.container.UnorderedList;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-sal-test-store</b>
 * <pre>
 * container unordered-container {
 *     list unordered-list {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *         leaf value {
 *             type string;
 *         }
 *         uses name-value;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-sal-test-store/lists/unordered-container</i>
 *
 * <p>To create instances of this class use {@link UnorderedContainerBuilder}.
 * @see UnorderedContainerBuilder
 *
 */
public interface UnorderedContainer
    extends
    ChildOf<Lists>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.UnorderedContainer>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:store",
        "2014-04-22", "unordered-container").intern();

    /**
     * @return <code>java.util.List</code> <code>unorderedList</code>, or <code>null</code> if not present
     */
    List<UnorderedList> getUnorderedList();

}

