package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.NameValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.OrderedContainer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-sal-test-store</b>
 * <pre>
 * list ordered-list {
 *     key "name";
 *     leaf name {
 *         type string;
 *     }
 *     leaf value {
 *         type string;
 *     }
 *     uses name-value;
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-sal-test-store/lists/ordered-container/ordered-list</i>
 *
 * <p>To create instances of this class use {@link OrderedListBuilder}.
 * @see OrderedListBuilder
 * @see OrderedListKey
 *
 */
public interface OrderedList
    extends
    ChildOf<OrderedContainer>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container.OrderedList>,
    NameValue,
    Identifiable<OrderedListKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:test:store",
        "2014-04-22", "ordered-list").intern();

    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.ordered.container.OrderedListKey</code> <code>key</code>, or <code>null</code> if not present
     */
    OrderedListKey getKey();

}

