/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItemKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ListItemBuilder
implements Builder<ListItem> {
    private Uint32 _op;
    private String _sip;
    private ListItemKey key;
    Map<Class<? extends Augmentation<ListItem>>, Augmentation<ListItem>> augmentation = Collections.emptyMap();

    public ListItemBuilder() {
    }

    public ListItemBuilder(ListItem base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ListItem>>, Augmentation<ListItem>>(aug);
        }
        this.key = base.key();
        this._op = base.getOp();
        this._sip = base.getSip();
    }

    public ListItemKey key() {
        return this.key;
    }

    public Uint32 getOp() {
        return this._op;
    }

    public String getSip() {
        return this._sip;
    }

    public <E$$ extends Augmentation<ListItem>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ListItemBuilder withKey(ListItemKey key) {
        this.key = key;
        return this;
    }

    public ListItemBuilder setOp(Uint32 value) {
        this._op = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ListItemBuilder setOp(Long value) {
        return this.setOp(CodeHelpers.compatUint((Long)value));
    }

    public ListItemBuilder setSip(String value) {
        this._sip = value;
        return this;
    }

    public ListItemBuilder addAugmentation(Augmentation<ListItem> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public ListItemBuilder addAugmentation(Class<? extends Augmentation<ListItem>> augmentationType, Augmentation<ListItem> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public ListItemBuilder removeAugmentation(Class<? extends Augmentation<ListItem>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private ListItemBuilder doAddAugmentation(Class<? extends Augmentation<ListItem>> augmentationType, Augmentation<ListItem> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ListItem>>, Augmentation<ListItem>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ListItem build() {
        return new ListItemImpl(this);
    }

    private static final class ListItemImpl
    extends AbstractAugmentable<ListItem>
    implements ListItem {
        private final Uint32 _op;
        private final String _sip;
        private final ListItemKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ListItemImpl(ListItemBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ListItemKey(base.getOp(), base.getSip());
            this._op = this.key.getOp();
            this._sip = this.key.getSip();
        }

        @Override
        public ListItemKey key() {
            return this.key;
        }

        @Override
        public Uint32 getOp() {
            return this._op;
        }

        @Override
        public String getSip() {
            return this._sip;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._op);
            result = 31 * result + Objects.hashCode(this._sip);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ListItem.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            ListItem other = (ListItem)obj;
            if (!Objects.equals(this._op, other.getOp())) {
                return false;
            }
            if (!Objects.equals(this._sip, other.getSip())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ListItemImpl otherImpl = (ListItemImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ListItem");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_op", (Object)this._op);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sip", (Object)this._sip);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

