package org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.fooroot;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link BarrootBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BarrootBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new BarrootBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BarrootBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BarrootBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class BarrootBuilder implements Builder<Barroot> {

    private Integer _type;
    private Integer _value;
    private BarrootKey key;


    Map<Class<? extends Augmentation<Barroot>>, Augmentation<Barroot>> augmentation = Collections.emptyMap();

    public BarrootBuilder() {
    }
    
    
    

    public BarrootBuilder(Barroot base) {
        Map<Class<? extends Augmentation<Barroot>>, Augmentation<Barroot>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._type = base.getType();
        this._value = base.getValue();
    }


    public BarrootKey key() {
        return key;
    }
    
    public Integer getType() {
        return _type;
    }
    
    public Integer getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Barroot>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BarrootBuilder withKey(final BarrootKey key) {
        this.key = key;
        return this;
    }
    
    public BarrootBuilder setType(final Integer value) {
        this._type = value;
        return this;
    }
    
    public BarrootBuilder setValue(final Integer value) {
        this._value = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BarrootBuilder addAugmentation(Augmentation<Barroot> augmentation) {
        Class<? extends Augmentation<Barroot>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BarrootBuilder removeAugmentation(Class<? extends Augmentation<Barroot>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Barroot build() {
        return new BarrootImpl(this);
    }

    private static final class BarrootImpl
        extends AbstractAugmentable<Barroot>
        implements Barroot {
    
        private final Integer _type;
        private final Integer _value;
        private final BarrootKey key;
    
        BarrootImpl(BarrootBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new BarrootKey(base.getType());
            }
            this._type = key.getType();
            this._value = base.getValue();
        }
    
        @Override
        public BarrootKey key() {
            return key;
        }
        
        @Override
        public Integer getType() {
            return _type;
        }
        
        @Override
        public Integer getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Barroot.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Barroot.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Barroot.bindingToString(this);
        }
    }
}
