package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.Root;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-test-bug-3090</b>
 * <pre>
 * list list-in-root {
 *   key "leaf-c leaf-a leaf-b";
 *   leaf leaf-a {
 *     type string;
 *   }
 *   leaf leaf-b {
 *     type string;
 *   }
 *   leaf leaf-c {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-test-bug-3090/root/list-in-root</i>
 *
 * <p>To create instances of this class use {@link ListInRootBuilder}.
 * @see ListInRootBuilder
 * @see ListInRootKey
 *
 */
@Generated("mdsal-binding-generator")
public interface ListInRoot
    extends
    ChildOf<Root>,
    Augmentable<ListInRoot>,
    Identifiable<ListInRootKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("list-in-root");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.@NonNull ListInRoot obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getLeafA());
        result = prime * result + Objects.hashCode(obj.getLeafB());
        result = prime * result + Objects.hashCode(obj.getLeafC());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.@NonNull ListInRoot thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getLeafA(), other.getLeafA())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLeafB(), other.getLeafB())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLeafC(), other.getLeafC())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.@NonNull ListInRoot obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ListInRoot");
        CodeHelpers.appendValue(helper, "leafA", obj.getLeafA());
        CodeHelpers.appendValue(helper, "leafB", obj.getLeafB());
        CodeHelpers.appendValue(helper, "leafC", obj.getLeafC());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return leafA, or {@code null} if it is not present.
     *
     * @return {@code java.lang.String} leafA, or {@code null} if it is not present.
     *
     */
    String getLeafA();
    
    /**
     * Return leafB, or {@code null} if it is not present.
     *
     * @return {@code java.lang.String} leafB, or {@code null} if it is not present.
     *
     */
    String getLeafB();
    
    /**
     * Return leafC, or {@code null} if it is not present.
     *
     * @return {@code java.lang.String} leafC, or {@code null} if it is not present.
     *
     */
    String getLeafC();
    
    @Override
    ListInRootKey key();

}

