package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.cont2;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.CustomEnum;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Contlist1Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Contlist1Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new Contlist1BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Contlist1Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Contlist1Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Contlist1Builder implements Builder<Contlist1> {

    private CustomEnum _attrEnum;
    private String _attrStr;
    private Contlist1Key key;


    Map<Class<? extends Augmentation<Contlist1>>, Augmentation<Contlist1>> augmentation = Collections.emptyMap();

    public Contlist1Builder() {
    }
    
    
    
    public Contlist1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.EnumGrouping arg) {
        this._attrEnum = arg.getAttrEnum();
    }
    

    public Contlist1Builder(Contlist1 base) {
        Map<Class<? extends Augmentation<Contlist1>>, Augmentation<Contlist1>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._attrStr = base.getAttrStr();
        this._attrEnum = base.getAttrEnum();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.EnumGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.EnumGrouping) {
            this._attrEnum = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.EnumGrouping)arg).getAttrEnum();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.EnumGrouping]");
    }

    public Contlist1Key key() {
        return key;
    }
    
    public CustomEnum getAttrEnum() {
        return _attrEnum;
    }
    
    public String getAttrStr() {
        return _attrStr;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Contlist1>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public Contlist1Builder withKey(final Contlist1Key key) {
        this.key = key;
        return this;
    }
    
    public Contlist1Builder setAttrEnum(final CustomEnum value) {
        this._attrEnum = value;
        return this;
    }
    
    public Contlist1Builder setAttrStr(final String value) {
        this._attrStr = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Contlist1Builder addAugmentation(Augmentation<Contlist1> augmentation) {
        Class<? extends Augmentation<Contlist1>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Contlist1Builder removeAugmentation(Class<? extends Augmentation<Contlist1>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Contlist1 build() {
        return new Contlist1Impl(this);
    }

    private static final class Contlist1Impl
        extends AbstractAugmentable<Contlist1>
        implements Contlist1 {
    
        private final CustomEnum _attrEnum;
        private final String _attrStr;
        private final Contlist1Key key;
    
        Contlist1Impl(Contlist1Builder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new Contlist1Key(base.getAttrStr());
            }
            this._attrStr = key.getAttrStr();
            this._attrEnum = base.getAttrEnum();
        }
    
        @Override
        public Contlist1Key key() {
            return key;
        }
        
        @Override
        public CustomEnum getAttrEnum() {
            return _attrEnum;
        }
        
        @Override
        public String getAttrStr() {
            return _attrStr;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Contlist1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Contlist1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Contlist1.bindingToString(this);
        }
    }
}
