package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ContainerWithUses;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUses;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TreeComplexUsesAugmentBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TreeComplexUsesAugmentBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TreeComplexUsesAugmentBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TreeComplexUsesAugmentBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TreeComplexUsesAugmentBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class TreeComplexUsesAugmentBuilder implements Builder<TreeComplexUsesAugment> {

    private ContainerWithUses _containerWithUses;
    private Map<ListViaUsesKey, ListViaUses> _listViaUses;



    public TreeComplexUsesAugmentBuilder() {
    }
    
    
    public TreeComplexUsesAugmentBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping arg) {
        this._containerWithUses = arg.getContainerWithUses();
        this._listViaUses = arg.getListViaUses();
    }

    public TreeComplexUsesAugmentBuilder(TreeComplexUsesAugment base) {
        this._containerWithUses = base.getContainerWithUses();
        this._listViaUses = base.getListViaUses();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping) {
            this._containerWithUses = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping)arg).getContainerWithUses();
            this._listViaUses = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping)arg).getListViaUses();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.ComplexFromGrouping]");
    }

    public ContainerWithUses getContainerWithUses() {
        return _containerWithUses;
    }
    
    public Map<ListViaUsesKey, ListViaUses> getListViaUses() {
        return _listViaUses;
    }

    
    public TreeComplexUsesAugmentBuilder setContainerWithUses(final ContainerWithUses value) {
        this._containerWithUses = value;
        return this;
    }
    public TreeComplexUsesAugmentBuilder setListViaUses(final Map<ListViaUsesKey, ListViaUses> values) {
        this._listViaUses = values;
        return this;
    }
    
    /**
      * Utility migration setter.
      *
      * <b>IMPORTANT NOTE</b>: This method does not completely match previous mechanics, as the list is processed as
      *                        during this method's execution. Any future modifications of the list are <b>NOT</b>
      *                        reflected in this builder nor its products.
      *
      * @param values Legacy List of values
      * @return this builder
      * @throws IllegalArgumentException if the list contains entries with the same key
      * @throws NullPointerException if the list contains a null entry
      * @deprecated Use {@link #setListViaUses(Map)} instead.
      */
    @Deprecated(forRemoval = true)
    public TreeComplexUsesAugmentBuilder setListViaUses(final List<ListViaUses> values) {
        return setListViaUses(CodeHelpers.compatMap(values));
    }
    

    @Override
    public TreeComplexUsesAugment build() {
        return new TreeComplexUsesAugmentImpl(this);
    }

    private static final class TreeComplexUsesAugmentImpl
        implements TreeComplexUsesAugment {
    
        private final ContainerWithUses _containerWithUses;
        private final Map<ListViaUsesKey, ListViaUses> _listViaUses;
    
        TreeComplexUsesAugmentImpl(TreeComplexUsesAugmentBuilder base) {
            this._containerWithUses = base.getContainerWithUses();
            this._listViaUses = CodeHelpers.emptyToNull(base.getListViaUses());
        }
    
        @Override
        public ContainerWithUses getContainerWithUses() {
            return _containerWithUses;
        }
        
        @Override
        public Map<ListViaUsesKey, ListViaUses> getListViaUses() {
            return _listViaUses;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TreeComplexUsesAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TreeComplexUsesAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TreeComplexUsesAugment.bindingToString(this);
        }
    }
}
