package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.OrderedContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.UnkeyedContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.UnorderedContainer;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-sal-test-store</b>
 * <pre>
 * container lists {
 *   config false;
 *   container unordered-container {
 *     list unordered-list {
 *       key name;
 *       uses name-value;
 *     }
 *   }
 *   container ordered-container {
 *     list ordered-list {
 *       ordered-by user;
 *       key name;
 *       uses name-value;
 *     }
 *   }
 *   container unkeyed-container {
 *     list unkeyed-list {
 *       uses name-value;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-sal-test-store/lists</i>
 *
 * <p>To create instances of this class use {@link ListsBuilder}.
 * @see ListsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Lists
    extends
    ChildOf<OpendaylightSalTestStoreData>,
    Augmentable<Lists>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("lists");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.Lists> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.Lists.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.@NonNull Lists obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getOrderedContainer());
        result = prime * result + Objects.hashCode(obj.getUnkeyedContainer());
        result = prime * result + Objects.hashCode(obj.getUnorderedContainer());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.@NonNull Lists thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.Lists other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.Lists.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getOrderedContainer(), other.getOrderedContainer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUnkeyedContainer(), other.getUnkeyedContainer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUnorderedContainer(), other.getUnorderedContainer())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.@NonNull Lists obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Lists");
        CodeHelpers.appendValue(helper, "orderedContainer", obj.getOrderedContainer());
        CodeHelpers.appendValue(helper, "unkeyedContainer", obj.getUnkeyedContainer());
        CodeHelpers.appendValue(helper, "unorderedContainer", obj.getUnorderedContainer());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return unorderedContainer, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.UnorderedContainer} unorderedContainer, or {@code null} if it is not present.
     *
     */
    UnorderedContainer getUnorderedContainer();
    
    /**
     * Return orderedContainer, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.OrderedContainer} orderedContainer, or {@code null} if it is not present.
     *
     */
    OrderedContainer getOrderedContainer();
    
    /**
     * Return unkeyedContainer, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.store.rev140422.lists.UnkeyedContainer} unkeyedContainer, or {@code null} if it is not present.
     *
     */
    UnkeyedContainer getUnkeyedContainer();

}

