package org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.fooroot.Barroot;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.fooroot.BarrootKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link Fooroot} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Fooroot createFooroot(int fooXyzzy, int barBaz) {
 *         return new FoorootBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Fooroot, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Fooroot
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class FoorootBuilder implements Builder<Fooroot> {

    private Map<BarrootKey, Barroot> _barroot;


    Map<Class<? extends Augmentation<Fooroot>>, Augmentation<Fooroot>> augmentation = Collections.emptyMap();

    public FoorootBuilder() {
    }
    
    

    public FoorootBuilder(Fooroot base) {
        Map<Class<? extends Augmentation<Fooroot>>, Augmentation<Fooroot>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._barroot = base.getBarroot();
    }


    public Map<BarrootKey, Barroot> getBarroot() {
        return _barroot;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Fooroot>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public FoorootBuilder setBarroot(final Map<BarrootKey, Barroot> values) {
        this._barroot = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public FoorootBuilder addAugmentation(Augmentation<Fooroot> augmentation) {
        Class<? extends Augmentation<Fooroot>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public FoorootBuilder removeAugmentation(Class<? extends Augmentation<Fooroot>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Fooroot build() {
        return new FoorootImpl(this);
    }

    private static final class FoorootImpl
        extends AbstractAugmentable<Fooroot>
        implements Fooroot {
    
        private final Map<BarrootKey, Barroot> _barroot;
    
        FoorootImpl(FoorootBuilder base) {
            super(base.augmentation);
            this._barroot = CodeHelpers.emptyToNull(base.getBarroot());
        }
    
        @Override
        public Map<BarrootKey, Barroot> getBarroot() {
            return _barroot;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Fooroot.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Fooroot.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Fooroot.bindingToString(this);
        }
    }
}
