package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-of-migration-test-model</b>
 * <pre>
 * input input {
 *   leaf knocker-id {
 *     ext:context-reference routed:test-context;
 *     type instance-identifier;
 *   }
 *   leaf question {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>opendaylight-of-migration-test-modelknock-knockinput</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface KnockKnockInput
    extends
    RpcInput,
    Augmentable<KnockKnockInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.KnockKnockInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.KnockKnockInput.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.@NonNull KnockKnockInput obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getKnockerId());
        result = prime * result + Objects.hashCode(obj.getQuestion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.@NonNull KnockKnockInput thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.KnockKnockInput other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.KnockKnockInput.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getQuestion(), other.getQuestion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKnockerId(), other.getKnockerId())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.@NonNull KnockKnockInput obj) {
        final var helper = MoreObjects.toStringHelper("KnockKnockInput");
        CodeHelpers.appendValue(helper, "knockerId", obj.getKnockerId());
        CodeHelpers.appendValue(helper, "question", obj.getQuestion());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return knockerId, or {@code null} if it is not present.
     *
     * @return {@code InstanceIdentifier<?>} knockerId, or {@code null} if it is not present.
     *
     */
    @RoutingContext
    (
    value=org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.TestContext.class
    )
    InstanceIdentifier<?> getKnockerId();
    
    /**
     * Return knockerId, guaranteed to be non-null.
     *
     * @return {@code InstanceIdentifier<?>} knockerId, guaranteed to be non-null.
     * @throws NoSuchElementException if knockerId is not present
     *
     */
    default @NonNull InstanceIdentifier<?> requireKnockerId() {
        return CodeHelpers.require(getKnockerId(), "knockerid");
    }
    
    /**
     * Return question, or {@code null} if it is not present.
     *
     * @return {@code String} question, or {@code null} if it is not present.
     *
     */
    String getQuestion();
    
    /**
     * Return question, guaranteed to be non-null.
     *
     * @return {@code String} question, guaranteed to be non-null.
     * @throws NoSuchElementException if question is not present
     *
     */
    default @NonNull String requireQuestion() {
        return CodeHelpers.require(getQuestion(), "question");
    }

}

