package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link KnockKnockInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     KnockKnockInput createKnockKnockInput(int fooXyzzy, int barBaz) {
 *         return new KnockKnockInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of KnockKnockInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see KnockKnockInput
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class KnockKnockInputBuilder implements Builder<KnockKnockInput> {

    private InstanceIdentifier<?> _knockerId;
    private String _question;


    Map<Class<? extends Augmentation<KnockKnockInput>>, Augmentation<KnockKnockInput>> augmentation = Collections.emptyMap();

    public KnockKnockInputBuilder() {
    }
    
    

    public KnockKnockInputBuilder(KnockKnockInput base) {
        Map<Class<? extends Augmentation<KnockKnockInput>>, Augmentation<KnockKnockInput>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._knockerId = base.getKnockerId();
        this._question = base.getQuestion();
    }


    public InstanceIdentifier<?> getKnockerId() {
        return _knockerId;
    }
    
    public String getQuestion() {
        return _question;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<KnockKnockInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public KnockKnockInputBuilder setKnockerId(final InstanceIdentifier<?> value) {
        this._knockerId = value;
        return this;
    }
    
    public KnockKnockInputBuilder setQuestion(final String value) {
        this._question = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public KnockKnockInputBuilder addAugmentation(Augmentation<KnockKnockInput> augmentation) {
        Class<? extends Augmentation<KnockKnockInput>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public KnockKnockInputBuilder removeAugmentation(Class<? extends Augmentation<KnockKnockInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public KnockKnockInput build() {
        return new KnockKnockInputImpl(this);
    }

    private static final class KnockKnockInputImpl
        extends AbstractAugmentable<KnockKnockInput>
        implements KnockKnockInput {
    
        private final InstanceIdentifier<?> _knockerId;
        private final String _question;
    
        KnockKnockInputImpl(KnockKnockInputBuilder base) {
            super(base.augmentation);
            this._knockerId = base.getKnockerId();
            this._question = base.getQuestion();
        }
    
        @Override
        public InstanceIdentifier<?> getKnockerId() {
            return _knockerId;
        }
        
        @Override
        public String getQuestion() {
            return _question;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = KnockKnockInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return KnockKnockInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return KnockKnockInput.bindingToString(this);
        }
    }
}
