package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.aug.grouping.list1;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.BitFlags;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link List11} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     List11 createList11(int fooXyzzy, int barBaz) {
 *         return new List11Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of List11, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see List11
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class List11Builder implements Builder<List11> {

    private Integer _attrInt;
    private String _attrStr;
    private BitFlags _flags;
    private List11Key key;


    Map<Class<? extends Augmentation<List11>>, Augmentation<List11>> augmentation = Collections.emptyMap();

    public List11Builder() {
    }
    
    
    

    public List11Builder(List11 base) {
        Map<Class<? extends Augmentation<List11>>, Augmentation<List11>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._attrInt = base.getAttrInt();
        this._attrStr = base.getAttrStr();
        this._flags = base.getFlags();
    }


    public List11Key key() {
        return key;
    }
    
    public Integer getAttrInt() {
        return _attrInt;
    }
    
    public String getAttrStr() {
        return _attrStr;
    }
    
    public BitFlags getFlags() {
        return _flags;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<List11>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public List11Builder withKey(final List11Key key) {
        this.key = key;
        return this;
    }
    
    public List11Builder setAttrInt(final Integer value) {
        this._attrInt = value;
        return this;
    }
    
    public List11Builder setAttrStr(final String value) {
        this._attrStr = value;
        return this;
    }
    
    public List11Builder setFlags(final BitFlags value) {
        this._flags = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public List11Builder addAugmentation(Augmentation<List11> augmentation) {
        Class<? extends Augmentation<List11>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public List11Builder removeAugmentation(Class<? extends Augmentation<List11>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public List11 build() {
        return new List11Impl(this);
    }

    private static final class List11Impl
        extends AbstractAugmentable<List11>
        implements List11 {
    
        private final Integer _attrInt;
        private final String _attrStr;
        private final BitFlags _flags;
        private final List11Key key;
    
        List11Impl(List11Builder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new List11Key(base.getAttrInt());
            }
            this._attrInt = key.getAttrInt();
            this._attrStr = base.getAttrStr();
            this._flags = base.getFlags();
        }
    
        @Override
        public List11Key key() {
            return key;
        }
        
        @Override
        public Integer getAttrInt() {
            return _attrInt;
        }
        
        @Override
        public String getAttrStr() {
            return _attrStr;
        }
        
        @Override
        public BitFlags getFlags() {
            return _flags;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = List11.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return List11.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return List11.bindingToString(this);
        }
    }
}
