package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;

/**
 * Class that builds {@link RpcSecondLeafOnlyAugment} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RpcSecondLeafOnlyAugment createRpcSecondLeafOnlyAugment(int fooXyzzy, int barBaz) {
 *         return new RpcSecondLeafOnlyAugmentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RpcSecondLeafOnlyAugment, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RpcSecondLeafOnlyAugment
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class RpcSecondLeafOnlyAugmentBuilder implements Builder<RpcSecondLeafOnlyAugment> {

    private String _secondSimpleValue;



    public RpcSecondLeafOnlyAugmentBuilder() {
    }
    

    public RpcSecondLeafOnlyAugmentBuilder(RpcSecondLeafOnlyAugment base) {
        this._secondSimpleValue = base.getSecondSimpleValue();
    }


    public String getSecondSimpleValue() {
        return _secondSimpleValue;
    }

    
    public RpcSecondLeafOnlyAugmentBuilder setSecondSimpleValue(final String value) {
        this._secondSimpleValue = value;
        return this;
    }
    

    @Override
    public RpcSecondLeafOnlyAugment build() {
        return new RpcSecondLeafOnlyAugmentImpl(this);
    }

    private static final class RpcSecondLeafOnlyAugmentImpl
        implements RpcSecondLeafOnlyAugment {
    
        private final String _secondSimpleValue;
    
        RpcSecondLeafOnlyAugmentImpl(RpcSecondLeafOnlyAugmentBuilder base) {
            this._secondSimpleValue = base.getSecondSimpleValue();
        }
    
        @Override
        public String getSecondSimpleValue() {
            return _secondSimpleValue;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = RpcSecondLeafOnlyAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return RpcSecondLeafOnlyAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return RpcSecondLeafOnlyAugment.bindingToString(this);
        }
    }
}
