package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;

/**
 * Class that builds {@link TreeLeafOnlyAugment} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TreeLeafOnlyAugment createTreeLeafOnlyAugment(int fooXyzzy, int barBaz) {
 *         return new TreeLeafOnlyAugmentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TreeLeafOnlyAugment, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TreeLeafOnlyAugment
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class TreeLeafOnlyAugmentBuilder implements Builder<TreeLeafOnlyAugment> {

    private String _simpleValue;



    public TreeLeafOnlyAugmentBuilder() {
    }
    

    public TreeLeafOnlyAugmentBuilder(TreeLeafOnlyAugment base) {
        this._simpleValue = base.getSimpleValue();
    }


    public String getSimpleValue() {
        return _simpleValue;
    }

    
    public TreeLeafOnlyAugmentBuilder setSimpleValue(final String value) {
        this._simpleValue = value;
        return this;
    }
    

    @Override
    public TreeLeafOnlyAugment build() {
        return new TreeLeafOnlyAugmentImpl(this);
    }

    private static final class TreeLeafOnlyAugmentImpl
        implements TreeLeafOnlyAugment {
    
        private final String _simpleValue;
    
        TreeLeafOnlyAugmentImpl(TreeLeafOnlyAugmentBuilder base) {
            this._simpleValue = base.getSimpleValue();
        }
    
        @Override
        public String getSimpleValue() {
            return _simpleValue;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TreeLeafOnlyAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TreeLeafOnlyAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TreeLeafOnlyAugment.bindingToString(this);
        }
    }
}
