package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link ListItem} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ListItem createListItem(int fooXyzzy, int barBaz) {
 *         return new ListItemBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ListItem, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ListItem
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ListItemBuilder implements Builder<ListItem> {

    private Uint32 _op;
    private String _sip;
    private ListItemKey key;


    Map<Class<? extends Augmentation<ListItem>>, Augmentation<ListItem>> augmentation = Collections.emptyMap();

    public ListItemBuilder() {
    }
    
    
    

    public ListItemBuilder(ListItem base) {
        Map<Class<? extends Augmentation<ListItem>>, Augmentation<ListItem>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._op = base.getOp();
        this._sip = base.getSip();
    }


    public ListItemKey key() {
        return key;
    }
    
    public Uint32 getOp() {
        return _op;
    }
    
    public String getSip() {
        return _sip;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ListItem>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ListItemBuilder withKey(final ListItemKey key) {
        this.key = key;
        return this;
    }
    
    public ListItemBuilder setOp(final Uint32 value) {
        this._op = value;
        return this;
    }
    
    public ListItemBuilder setSip(final String value) {
        this._sip = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ListItemBuilder addAugmentation(Augmentation<ListItem> augmentation) {
        Class<? extends Augmentation<ListItem>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ListItemBuilder removeAugmentation(Class<? extends Augmentation<ListItem>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ListItem build() {
        return new ListItemImpl(this);
    }

    private static final class ListItemImpl
        extends AbstractAugmentable<ListItem>
        implements ListItem {
    
        private final Uint32 _op;
        private final String _sip;
        private final ListItemKey key;
    
        ListItemImpl(ListItemBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ListItemKey(base.getOp(), base.getSip());
            }
            this._op = key.getOp();
            this._sip = key.getSip();
        }
    
        @Override
        public ListItemKey key() {
            return key;
        }
        
        @Override
        public Uint32 getOp() {
            return _op;
        }
        
        @Override
        public String getSip() {
            return _sip;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ListItem.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ListItem.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ListItem.bindingToString(this);
        }
    }
}
