package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.of.migration.test.model.rev150210.list11.simple.augment.Cont;

/**
 * Class that builds {@link List11SimpleAugment} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     List11SimpleAugment createList11SimpleAugment(int fooXyzzy, int barBaz) {
 *         return new List11SimpleAugmentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of List11SimpleAugment, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see List11SimpleAugment
 *
 */
@Generated("mdsal-binding-generator")
public class List11SimpleAugmentBuilder {

    private String _attrStr2;
    private Cont _cont;



    public List11SimpleAugmentBuilder() {
    }
    

    public List11SimpleAugmentBuilder(List11SimpleAugment base) {
        this._attrStr2 = base.getAttrStr2();
        this._cont = base.getCont();
    }


    public String getAttrStr2() {
        return _attrStr2;
    }
    
    public Cont getCont() {
        return _cont;
    }

    
    public List11SimpleAugmentBuilder setAttrStr2(final String value) {
        this._attrStr2 = value;
        return this;
    }
    
    public List11SimpleAugmentBuilder setCont(final Cont value) {
        this._cont = value;
        return this;
    }
    

    /**
     * A new {@link List11SimpleAugment} instance.
     *
     * @return A new {@link List11SimpleAugment} instance.
     */
    public List11SimpleAugment build() {
        return new List11SimpleAugmentImpl(this);
    }

    private static final class List11SimpleAugmentImpl
        implements List11SimpleAugment {
    
        private final String _attrStr2;
        private final Cont _cont;
    
        List11SimpleAugmentImpl(List11SimpleAugmentBuilder base) {
            this._attrStr2 = base.getAttrStr2();
            this._cont = base.getCont();
        }
    
        @Override
        public String getAttrStr2() {
            return _attrStr2;
        }
        
        @Override
        public Cont getCont() {
            return _cont;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = List11SimpleAugment.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return List11SimpleAugment.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return List11SimpleAugment.bindingToString(this);
        }
    }
}
